/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.substitutabilityManagers;

import abscon.constraints.Constraint;
import abscon.constraints.TupleManager;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.substitutabilityManagers.SubstitutabilityManager;
import abscon.propagationTechniques.supportManagers.SupportManager;
import abscon.propagationTechniques.supportManagers.SupportManager2001;
import abscon.propagationTechniques.supportManagers.supportUnits.SupportUnit2001b;
import abscon.tools.elements.Elements;

public class SubstitutabilityManager2
extends SubstitutabilityManager {
    private SupportManager2001 supportManager2001b;

    public SubstitutabilityManager2(ForwardPropagationTechnique forwardPropagationTechnique) {
        super(forwardPropagationTechnique);
        SupportManager supportManager = forwardPropagationTechnique.getSupportManager();
        if (!(supportManager instanceof SupportManager2001)) {
            throw new IncompatiblePropertiesException();
        }
        this.supportManager2001b = (SupportManager2001)supportManager;
    }

    private boolean isDetectedAsUnsubstitutable(Constraint constraint, Variable variable, int index, int otherIndex) {
        SupportUnit2001b supportUnit2001b = (SupportUnit2001b)this.supportManager2001b.getSupportUnitOf(constraint, variable);
        return supportUnit2001b.isLastSupportStrictlyLessThan(index, otherIndex);
    }

    public boolean isSubstitutableBy(Constraint constraint, Variable variable, int index, int otherIndex) {
        SupportUnit2001b supportUnit2001b = (SupportUnit2001b)this.supportManager2001b.getSupportUnitOf(constraint, variable);
        int[] lastSupport = supportUnit2001b.getLastSupportOf(index);
        assert (constraint.checkValidityOf(lastSupport));
        int position = constraint.getPositionOf(variable);
        TupleManager tupleManager = constraint.getTupleManager();
        int[] tuple = tupleManager.getLocalTuple();
        tupleManager.setFirstTupleFromScratch(tuple, position, index);
        tuple[0] = lastSupport[0];
        tuple[1] = lastSupport[1];
        do {
            if (!constraint.checkCurrentTupleOfAssistant()) continue;
            tuple[position] = otherIndex;
            if (!constraint.checkCurrentTupleOfAssistant()) {
                return false;
            }
            tuple[position] = index;
        } while (tupleManager.setNextTuple() != -1);
        return true;
    }

    public boolean isSubstitutableBy(Variable variable, int index, int otherIndex) {
        Constraint constraint;
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            constraint = constraintArray[n];
            if (this.isDetectedAsUnsubstitutable(constraint, variable, index, otherIndex)) {
                return false;
            }
            ++n;
        }
        constraintArray = variable.getInvolvingConstraints();
        n = 0;
        n2 = constraintArray.length;
        while (n < n2) {
            constraint = constraintArray[n];
            if (!this.isSubstitutableBy(constraint, variable, index, otherIndex)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isSubstitutable(Variable variable, int index) {
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            SupportUnit2001b supportUnit2001b = (SupportUnit2001b)this.supportManager2001b.getSupportUnitOf(constraint, variable);
            if (!supportUnit2001b.getArcSupportOf(index)) {
                return true;
            }
            ++n;
        }
        Elements elements = variable.getDomain().getElements();
        int otherIndex = elements.getFirstPresent();
        while (otherIndex != -1) {
            if (otherIndex != index && this.isSubstitutableBy(variable, index, otherIndex)) {
                return true;
            }
            otherIndex = elements.getNextPresent(otherIndex);
        }
        return false;
    }
}

