/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.revisionManagers.revisionUnits;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.revisionManagers.RevisionManager;
import abscon.propagationTechniques.revisionManagers.revisionUnits.RevisionUnit;
import abscon.tools.elements.Elements;

public class RevisionUnit1Old
extends RevisionUnit {
    protected long[] nbConflicts;
    protected long nbMaxConflicts;
    private int[] covering;
    int[] tmp = new int[5];

    public void incrementNbConflictsOf(int index) {
        if (this.nbConflicts[index] == Long.MAX_VALUE) {
            throw new ArithmeticException();
        }
        int n = index;
        this.nbConflicts[n] = this.nbConflicts[n] + 1L;
    }

    public void fixNbMaxConflicts() {
        long max = -1L;
        Elements elements = this.domain.getElements();
        int cpt = 0;
        int index = elements.getFirstPresent();
        while (index != -1) {
            if (this.nbConflicts[index] > max) {
                max = this.nbConflicts[index];
            } else if (this.nbConflicts[index] == 0L && cpt < this.tmp.length) {
                this.tmp[cpt++] = index;
            }
            index = elements.getNextPresent(index);
        }
        this.nbMaxConflicts = max;
        this.covering = new int[cpt];
        int i = 0;
        while (i < this.covering.length) {
            this.covering[i] = this.tmp[i];
            ++i;
        }
        assert (this.controlNbConflicts());
    }

    public RevisionUnit1Old(RevisionManager revisionManager, Constraint constraint, Variable variable) {
        super(revisionManager, constraint, variable);
    }

    public boolean mustBeRevised() {
        if (this.nbMaxConflicts == -10L) {
            return true;
        }
        if (this.constraint.getDomainManager().getDCurrentDomainSizeExcluding(this.variablePosition) > (double)this.nbMaxConflicts) {
            return false;
        }
        if (this.covering == null) {
            return true;
        }
        Variable[] involvedVariables = this.constraint.getInvolvedVariables();
        int i = 0;
        while (i < involvedVariables.length) {
            if (i != this.variablePosition) {
                RevisionUnit1Old revisionUnit = (RevisionUnit1Old)this.revisionManager.getRevisions(this.constraint, i);
                int j = 0;
                while (j < revisionUnit.covering.length) {
                    if (involvedVariables[i].getDomain().hasIndex(revisionUnit.covering[j])) {
                        return false;
                    }
                    ++j;
                }
                return true;
            }
            ++i;
        }
        return true;
    }

    public void revise() {
        double d = this.constraint.getDomainManager().getDCurrentDomainSizeExcluding(this.variablePosition);
        if (this.nbMaxConflicts == -10L) {
            d = -10.0;
        }
        Elements elements = this.domain.getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            if (!(d > (double)this.nbConflicts[index]) && !this.supportManager.seekNextSupport(this.constraint.getId(), this.variablePosition, index)) {
                this.domain.removeElementAt(index, this.constraint);
            }
            index = elements.getNextPresent(index);
        }
    }

    public void display() {
        super.display();
        System.out.print("  nbConflicts : ");
        Elements elements = this.domain.getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            System.out.print(String.valueOf(index) + "->" + this.nbConflicts[index] + " ");
            index = elements.getNextPresent(index);
        }
        System.out.println("\n  nbMaxConflicts = " + this.nbMaxConflicts);
    }

    private boolean controlNbConflicts() {
        Elements elements = this.domain.getElements();
        if (this.nbMaxConflicts == -10L) {
            int index = elements.getFirstPresent();
            while (index != -1) {
                if (this.nbConflicts[index] != -10L) {
                    return false;
                }
                index = elements.getNextPresent(index);
            }
            return true;
        }
        int index = elements.getFirstPresent();
        while (index != -1) {
            if (this.nbConflicts[index] == -10L) {
                return false;
            }
            index = elements.getNextPresent(index);
        }
        return true;
    }
}

