/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.revisionManagers.revisionUnits;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.revisionManagers.RevisionManager;
import abscon.propagationTechniques.supportManagers.SupportManager;

public abstract class RevisionUnit {
    protected RevisionManager revisionManager;
    protected Constraint constraint;
    protected Variable variable;
    protected int variablePosition;
    protected Domain domain;
    protected SupportManager supportManager;

    public Constraint getConstraint() {
        return this.constraint;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public RevisionUnit(RevisionManager revisionManager, Constraint constraint, Variable variable) {
        this.revisionManager = revisionManager;
        this.constraint = constraint;
        this.variable = variable;
        this.variablePosition = constraint.getPositionOf(variable);
        this.domain = variable.getDomain();
        this.supportManager = revisionManager.getPropagationTechnique().getSupportManager();
    }

    public abstract boolean mustBeRevised();

    public abstract void revise();

    public void display() {
        System.out.println("Revision unit of " + this.constraint + " " + this.variable);
    }
}

