/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.revisionManagers;

import abscon.constraints.Constraint;
import abscon.constraints.extension.ExtensionConstraint;
import abscon.constraints.extension.structures.Bits;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.revisionManagers.RevisionManager1;
import abscon.tools.Tools;
import abscon.tools.elements.Elements;
import abscon.xml.OutputManager;

public class RevisionManager6
extends RevisionManager1 {
    public static final int RESIDUE_LIMIT = 500;
    private short[][][] residues;
    private boolean test = true;
    private int cpt = 0;

    public void buildStructures() {
        if (ExtensionConstraint.getNbResidues() == 0L) {
            return;
        }
        if (ExtensionConstraint.getNbResidues() * 2L + Tools.getUsedMemory() > 550000000L) {
            OutputManager.printInfo("Not creating residues ");
            return;
        }
        Constraint[] constraints = this.propagationTechnique.getSolver().getConstraints();
        this.residues = new short[constraints.length][2][];
        int cpt = 0;
        Constraint[] constraintArray = constraints;
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getExtensionStructure() instanceof Bits) {
                int max0 = constraint.getInvolvedVariable(0).getDomain().getMaximumSize();
                int max1 = constraint.getInvolvedVariable(1).getDomain().getMaximumSize();
                if (max0 > 500 || max1 > 500) {
                    ++cpt;
                    if (max0 > 500) {
                        this.residues[constraint.getId()][1] = new short[max1];
                    }
                    if (max1 > 500) {
                        this.residues[constraint.getId()][0] = new short[max0];
                    }
                }
            }
            ++n;
        }
        if (cpt == 0) {
            this.residues = null;
        }
    }

    public void revise(Constraint constraint, Variable variable) {
        short[] indexLevelResidues;
        if (!(constraint.getExtensionStructure() instanceof Bits)) {
            super.revise(constraint, variable);
            return;
        }
        Problem problem = this.propagationTechnique.getSolver().getProblem();
        int variablePosition = constraint.getPositionOf(variable);
        int brotherPosition = variablePosition == 0 ? 1 : 0;
        Domain domain = variable.getDomain();
        Elements elements = domain.getElements();
        Elements brotherElements = constraint.getInvolvedVariable(brotherPosition).getDomain().getElements();
        Bits bits = (Bits)constraint.getExtensionStructure();
        long[] binaryRepresentationOfBrotherVariableDomain = brotherElements.getBinaryRepresentation();
        long[][] binaryRepresentationOfSupports = bits.getBinaryRepresentationOfSupportsOf(variablePosition);
        if (this.residues != null && (indexLevelResidues = this.residues[constraint.getId()][variablePosition]) != null) {
            int index = elements.getFirstPresent();
            while (index != -1) {
                long[] binaryRepresentationOfIndexSupports = binaryRepresentationOfSupports[index];
                short residueValue = indexLevelResidues[index];
                if ((binaryRepresentationOfIndexSupports[residueValue] & binaryRepresentationOfBrotherVariableDomain[residueValue]) == 0L) {
                    int i = 0;
                    while (i < binaryRepresentationOfIndexSupports.length) {
                        problem.incrementNbConstraintChecks();
                        if ((binaryRepresentationOfIndexSupports[i] & binaryRepresentationOfBrotherVariableDomain[i]) != 0L) break;
                        ++i;
                    }
                    if (i == binaryRepresentationOfIndexSupports.length) {
                        domain.removeElementAt(index, constraint);
                    } else {
                        indexLevelResidues[index] = (short)i;
                    }
                }
                index = elements.getNextPresent(index);
            }
            return;
        }
        int index = elements.getFirstPresent();
        while (index != -1) {
            long[] binaryRepresentationOfIndexSupports = binaryRepresentationOfSupports[index];
            int i = 0;
            while (i < binaryRepresentationOfIndexSupports.length) {
                problem.incrementNbConstraintChecks();
                if ((binaryRepresentationOfIndexSupports[i] & binaryRepresentationOfBrotherVariableDomain[i]) != 0L) break;
                ++i;
            }
            if (i == binaryRepresentationOfIndexSupports.length) {
                domain.removeElementAt(index, constraint);
            }
            index = elements.getNextPresent(index);
        }
    }
}

