/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.revisionManagers;

import abscon.constraints.ConflictsStructure;
import abscon.constraints.Constraint;
import abscon.constraints.TupleManager;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.revisionManagers.RevisionManager1;
import abscon.propagationTechniques.revisionManagers.revisionUnits.RevisionUnit;
import abscon.propagationTechniques.revisionManagers.revisionUnits.RevisionUnit1;
import abscon.propagationTechniques.revisionManagers.revisionUnits.RevisionUnit2;
import abscon.solvers.systematicSolvers.SystematicStatistics;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ConfigurationManager;

public class RevisionManager2
extends RevisionManager1 {
    private boolean currentDomainMode;

    public boolean isCurrentDomainMode() {
        return this.currentDomainMode;
    }

    public void attachTo(ForwardPropagationTechnique propagationTechnique) {
        int mode = ConfigurationManager.getInt(propagationTechnique.getSolver().getLevelInResolution(), String.valueOf(propagationTechnique.getPhase()) + "/" + "propagationTechnique" + "/" + "revisionManager", "variant");
        this.currentDomainMode = mode == 1;
        super.attachTo(propagationTechnique);
    }

    private void computePartialOrdersFor(Constraint constraint) {
        int j;
        int i = constraint.getId();
        TupleManager assistant = constraint.getTupleManager();
        int[] tuple = assistant.getLocalTuple();
        assistant.setFirstTupleFromScratch(tuple);
        do {
            if (!constraint.checkCurrentTupleOfAssistant()) continue;
            j = 0;
            while (j < this.revisionUnit[i].length) {
                ((RevisionUnit2)this.revisionUnit[i][j]).storeNewSupport(tuple);
                ++j;
            }
        } while (assistant.setNextTuple() != -1);
        j = 0;
        while (j < this.revisionUnit[i].length) {
            ((RevisionUnit2)this.revisionUnit[i][j]).fixNbConflicts();
            ((RevisionUnit2)this.revisionUnit[i][j]).sortIndexes();
            ++j;
        }
    }

    public void buildStructures() {
        Constraint[] constraints = this.propagationTechnique.getSolver().getProblem().getConstraints();
        this.revisionUnit = new RevisionUnit[constraints.length][];
        int i = 0;
        while (i < constraints.length) {
            Variable[] involvedVariables = constraints[i].getInvolvedVariables();
            this.revisionUnit[i] = new RevisionUnit[involvedVariables.length];
            int j = 0;
            while (j < involvedVariables.length) {
                this.revisionUnit[i][j] = constraints[i].getArity() > 2 ? new RevisionUnit1(this, constraints[i], involvedVariables[j]) : new RevisionUnit2(this, constraints[i], involvedVariables[j]);
                ++j;
            }
            ++i;
        }
    }

    public void initializeStructures() {
        Constraint[] constraintArray = this.propagationTechnique.getSolver().getProblem().getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getArity() == 2) {
                this.computePartialOrdersFor(constraint);
            } else if (constraint.getConflictsStructure() == null) {
                constraint.setConflictsStructure(ConflictsStructure.build(constraint));
            }
            ++n;
        }
        long nb = this.propagationTechnique.getSolver().getProblem().getNbConstraintChecks();
        ((SystematicStatistics)this.propagationTechnique.getSolver().getStatistics()).setNbBeforeSearchConstraintChecks(nb);
    }

    public String getDescription(boolean full) {
        return String.valueOf(full ? "Revision manager = " : "") + Tools.getRelativeClassNameOf(this) + " (" + this.currentDomainMode + ")" + (full ? "\n" : " ");
    }
}

