/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.revisionManagers;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.revisionManagers.revisionUnits.RevisionUnit;
import java.util.Arrays;

public abstract class RevisionManager {
    protected ForwardPropagationTechnique propagationTechnique;
    protected RevisionUnit[][] revisionUnit;
    protected int[][][] relationRepartitions0;
    protected int[][][] access;
    private boolean test = false;

    public ForwardPropagationTechnique getPropagationTechnique() {
        return this.propagationTechnique;
    }

    public RevisionUnit getRevisions(Constraint constraint, int variablePosition) {
        return this.revisionUnit[constraint.getId()][variablePosition];
    }

    public void attachTo(ForwardPropagationTechnique propagationTechnique) {
        this.propagationTechnique = propagationTechnique;
        this.buildStructures();
        if (this.test) {
            this.manageRelationRepartitions();
        }
    }

    public abstract void buildStructures();

    public abstract void initializeStructures();

    public abstract boolean mustBeRevised(Constraint var1, Variable var2);

    public abstract void revise(Constraint var1, Variable var2);

    public void reinitAccessFor(Variable variable) {
        if (this.relationRepartitions0 == null) {
            return;
        }
        int i = 0;
        while (i < this.access[variable.getId()].length) {
            Arrays.fill(this.access[variable.getId()][i], 0);
            ++i;
        }
    }

    private void manageRelationRepartitions() {
        int nbRelationTypes = this.propagationTechnique.getSolver().getProblem().getNbRelationTypes();
        int[] tmp = new int[]{};
        if (this.test && nbRelationTypes != -1) {
            Variable[] variables = this.propagationTechnique.getSolver().getVariables();
            this.relationRepartitions0 = new int[variables.length][nbRelationTypes][];
            this.access = new int[variables.length][][];
            Variable[] variableArray = variables;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable variable = variableArray[n];
                int variableId = variable.getId();
                int cpt = 0;
                Constraint[] constraintArray = variable.getInvolvingConstraints();
                int n3 = 0;
                int n4 = constraintArray.length;
                while (n3 < n4) {
                    Constraint constraint = constraintArray[n3];
                    if (constraint.getPositionOf(variable) == 0) {
                        int relationId = 0;
                        if (this.relationRepartitions0[variableId][relationId] == null) {
                            this.relationRepartitions0[variableId][relationId] = tmp;
                        } else if (this.relationRepartitions0[variableId][relationId] == tmp) {
                            int size = constraint.getFirstVariableDifferentFrom(variable).getDomain().getMaximumSize();
                            this.relationRepartitions0[variableId][relationId] = new int[size + 1];
                            this.relationRepartitions0[variableId][relationId][size] = 2;
                            ++cpt;
                        } else {
                            int last = this.relationRepartitions0[variableId][relationId].length;
                            int[] nArray = this.relationRepartitions0[variableId][relationId];
                            int n5 = last - 1;
                            nArray[n5] = nArray[n5] + 1;
                        }
                    }
                    ++n3;
                }
                this.access[variableId] = new int[cpt][];
                cpt = 0;
                int relationId = 0;
                while (relationId < this.relationRepartitions0[variableId].length) {
                    if (this.relationRepartitions0[variableId][relationId] == tmp) {
                        this.relationRepartitions0[variableId][relationId] = null;
                    }
                    if (this.relationRepartitions0[variableId][relationId] != null) {
                        this.access[variableId][cpt++] = this.relationRepartitions0[variableId][relationId];
                        System.out.println(variable + " with rel" + relationId + " : " + this.relationRepartitions0[variableId][relationId][this.relationRepartitions0[variableId][relationId].length - 1] + " constraints");
                    }
                    ++relationId;
                }
                ++n;
            }
        }
    }

    public void display() {
        System.out.println("Revision manager = " + this.getClass().getName());
        if (this.revisionUnit != null) {
            int i = 0;
            while (i < this.revisionUnit.length) {
                int j = 0;
                while (j < this.revisionUnit[i].length) {
                    this.revisionUnit[i][j].display();
                    ++j;
                }
                ++i;
            }
        }
    }
}

