/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.propagationSets;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSet;
import abscon.solvers.variableManagers.VariableManager;

public class PropagationSetOfVariables
extends PropagationSet {
    private int[] limitors;

    public void attachTo(PropagationTechnique propagationTechnique) {
        super.attachTo(propagationTechnique);
        this.capacity = propagationTechnique.getSolver().getProblem().getNbVariables();
        this.positionOfElements = new int[this.capacity];
        this.variables = new Variable[this.capacity];
        this.clear();
    }

    public void fill() {
        Variable[] variableArray = this.propagationTechnique.getSolver().getVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable v = variableArray[n];
            this.add(v);
            ++n;
        }
        this.propagationTechnique.getSolver().getProblem().updateConstraintDomainManagers(1);
    }

    public void fillWithPastVariables() {
        Variable[] variableArray = this.propagationTechnique.getSolver().getVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable v = variableArray[n];
            if (v.isAssigned()) {
                this.add(v);
            }
            ++n;
        }
    }

    public void initAfterModificationOf(Variable variable) {
        this.add(variable);
        variable.updateConstraintDomainManagers(1);
        this.revisionOrderingHeuristic.initAfterModificationOf(variable);
    }

    private void incrementLimitor(int i) {
        this.limitors[i] = Math.min(this.limitors[i] + 1, this.propagationTechnique.getSolver().getVariable(i).getDomain().getMaximumSize());
    }

    private void decrementLimitor(int i) {
        this.limitors[i] = Math.max(this.limitors[i] - 1, 1);
    }

    public boolean pickElementAndCheckConsistency() {
        int selection = this.revisionOrderingHeuristic.getIndexOfBestPropagationElement();
        Variable variable = this.getVariable(selection);
        this.remove(selection);
        ((ForwardPropagationTechnique)this.propagationTechnique).getRevisionManager().reinitAccessFor(variable);
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (this.propagationTechnique.admits(constraint) && constraint.getDomainManager().hasRecentReducedDomain(variable) && !this.propagationTechnique.isConsistent(constraint)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void updateAfterEffectiveRevisionOf(Constraint constraint, Variable variable, int nbRemovals) {
        if (!this.propagationTechnique.isMultiPass()) {
            return;
        }
        this.add(variable);
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint currentConstraint = constraintArray[n];
            if (currentConstraint != constraint || this.useBackRevisions()) {
                currentConstraint.getDomainManager().incrementNbRecentDomainRemovals(variable, nbRemovals);
            }
            ++n;
        }
    }

    public void add(Variable variable) {
        int position;
        if (this.positionOfElements[variable.getId()] != -1) {
            return;
        }
        this.positionOfElements[variable.getId()] = position = (this.head + this.size) % this.capacity;
        this.variables[position] = variable;
        ++this.size;
    }

    public void addNeighboursOf(Variable variable) {
        VariableManager variableManager = this.propagationTechnique.getSolver().getVariableManager();
        Variable[] neighbours = variable.getNeighbours();
        if (neighbours != null && neighbours.length <= variableManager.getNbFutureVariables()) {
            Variable[] variableArray = neighbours;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable neighbour = variableArray[n];
                if (!neighbour.isAssigned()) {
                    this.add(neighbour);
                }
                ++n;
            }
        } else {
            Variable var = variableManager.getFirstFutureVariable();
            while (var != null) {
                if (variable != var && variable.isNeighbourOf(var)) {
                    this.add(var);
                }
                var = variableManager.getNextFutureVariableAfter(var);
            }
        }
    }

    public void remove(int i) {
        assert (i < this.size);
        int position = (this.head + i) % this.capacity;
        Variable variable = this.variables[position];
        if (position == this.head) {
            this.head = (this.head + 1) % this.capacity;
        } else if (position != (this.head + this.size - 1) % this.capacity) {
            Variable lastVariable;
            this.variables[position] = lastVariable = this.getLastVariable();
            this.positionOfElements[lastVariable.getId()] = position;
        }
        this.positionOfElements[variable.getId()] = -1;
        --this.size;
    }

    public void swap(int i, int j) {
        assert (i < this.size && j < this.size);
        int pos1 = (this.head + i) % this.capacity;
        int pos2 = (this.head + j) % this.capacity;
        Variable tmp = this.variables[pos1];
        this.variables[pos1] = this.variables[pos2];
        this.variables[pos2] = tmp;
        this.positionOfElements[this.variables[pos1].getId()] = pos1;
        this.positionOfElements[this.variables[pos2].getId()] = pos2;
    }

    public void display() {
        super.display();
        int i = 0;
        while (i < this.size) {
            System.out.print(this.getVariable(i) + " ");
            ++i;
        }
        System.out.println();
    }
}

