/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.propagationSets;

import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSet;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;

public class PropagationSetOfRemovals
extends PropagationSet {
    private int[] offsets;
    private int[] cpts;
    private boolean test = true;

    public void attachTo(PropagationTechnique propagationTechnique) {
        this.propagationTechnique = propagationTechnique;
        Problem problem = propagationTechnique.getSolver().getProblem();
        this.capacity = 0;
        this.offsets = new int[problem.getNbVariables()];
        int i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = this.capacity;
            this.capacity += problem.getVariable(i).getDomain().getMaximumSize();
            ++i;
        }
        this.positionOfElements = new int[this.capacity];
        this.variables = new Variable[this.capacity];
        this.indexes = new int[this.capacity];
        this.clear();
        if (this.test) {
            this.cpts = new int[problem.getNbVariables()];
        }
    }

    public void fill() {
        VariableManager variableManager = this.propagationTechnique.getSolver().getVariableManager();
        Variable variable = variableManager.getFirstFutureVariable();
        while (variable != null) {
            Elements elements = variable.getDomain().getElements();
            int index = elements.getFirstPresent();
            while (index != -1) {
                this.add(variable, index);
                index = elements.getNextPresent(index);
            }
            variable = variableManager.getNextFutureVariableAfter(variable);
        }
    }

    public void fillWithBounds() {
        VariableManager variableManager = this.propagationTechnique.getSolver().getVariableManager();
        Variable variable = variableManager.getFirstFutureVariable();
        while (variable != null) {
            Elements elements = variable.getDomain().getElements();
            this.add(variable, elements.getFirstPresent());
            this.add(variable, elements.getLastPresent());
            variable = variableManager.getNextFutureVariableAfter(variable);
        }
    }

    public void fill(boolean bound) {
        this.clear();
        if (bound) {
            this.fillWithBounds();
        } else {
            this.fill();
        }
    }

    public boolean isPresent(Variable variable, int index) {
        int idElement = this.offsets[variable.getId()] + index;
        return this.positionOfElements[idElement] != -1;
    }

    public int getPositionOf(Variable variable, int index) {
        assert (this.isPresent(variable, index));
        int idElement = this.offsets[variable.getId()] + index;
        int absolutePosition = this.positionOfElements[idElement];
        if (this.head <= absolutePosition) {
            return absolutePosition - this.head;
        }
        return absolutePosition + (this.capacity - this.head);
    }

    public void add(Variable variable, int index) {
        int position;
        int idElement = this.offsets[variable.getId()] + index;
        if (this.positionOfElements[idElement] != -1) {
            return;
        }
        this.positionOfElements[idElement] = position = (this.head + this.size) % this.capacity;
        this.variables[position] = variable;
        this.indexes[position] = index;
        ++this.size;
        if (this.test) {
            int n = variable.getId();
            this.cpts[n] = this.cpts[n] + 1;
        }
    }

    public void remove(int i) {
        int position = (this.head + i) % this.capacity;
        Variable variable = this.variables[position];
        int index = this.indexes[position];
        if (position == this.head) {
            this.head = (this.head + 1) % this.capacity;
        } else if (position != (this.head + this.size - 1) % this.capacity) {
            Variable lastVariable = this.getLastVariable();
            int lastIndex = this.getLastIndex();
            this.variables[position] = lastVariable;
            this.indexes[position] = lastIndex;
            this.positionOfElements[this.offsets[lastVariable.getId()] + lastIndex] = position;
        }
        this.positionOfElements[this.offsets[variable.getId()] + index] = -1;
        --this.size;
        if (this.test) {
            int n = variable.getId();
            this.cpts[n] = this.cpts[n] - 1;
        }
    }

    public boolean has(Variable variable) {
        return this.cpts[variable.getId()] > 0;
    }

    public void removeIfPresent(Variable variable, int index) {
        int idElement = this.offsets[variable.getId()] + index;
        int position = this.positionOfElements[idElement];
        if (position == -1) {
            return;
        }
        this.remove(position);
    }

    public int getFirstPositionInvolving(Variable variable) {
        int offset = this.offsets[variable.getId()];
        Elements elements = variable.getDomain().getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            int position = this.positionOfElements[offset + index];
            if (position != -1) {
                if (this.head <= position) {
                    return position - this.head;
                }
                return position + (this.capacity - this.head);
            }
            index = elements.getNextPresent(index);
        }
        return -1;
    }

    public void swap(int i, int j) {
        int k = (this.head + i) % this.capacity;
        int l = (this.head + j) % this.capacity;
        Variable tmpV = this.variables[k];
        int tmpI = this.indexes[k];
        this.variables[k] = this.variables[l];
        this.indexes[k] = this.indexes[l];
        this.variables[l] = tmpV;
        this.indexes[l] = tmpI;
        this.positionOfElements[this.offsets[this.variables[k].getId()] + this.indexes[k]] = k;
        this.positionOfElements[this.offsets[this.variables[l].getId()] + this.indexes[l]] = l;
    }

    public void display() {
        super.display();
        int i = 0;
        while (i < this.size) {
            System.out.print("(" + this.getVariable(i) + "," + this.getIndex(i) + ") ");
            ++i;
        }
        System.out.println();
    }

    public void initAfterModificationOf(Variable variable) {
    }

    public boolean pickElementAndCheckConsistency() {
        return false;
    }
}

