/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.propagationSets;

import abscon.constraints.Constraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSet;

public class PropagationSetOfArcs
extends PropagationSet {
    private int[] offsets;

    public void attachTo(PropagationTechnique propagationTechnique) {
        super.attachTo(propagationTechnique);
        Problem problem = propagationTechnique.getSolver().getProblem();
        this.capacity = 0;
        this.offsets = new int[problem.getNbConstraints()];
        int i = 0;
        while (i < this.offsets.length) {
            this.offsets[i] = this.capacity;
            this.capacity += problem.getConstraint(i).getNbInvolvedVariables();
            ++i;
        }
        this.positionOfElements = new int[this.capacity];
        this.variables = new Variable[this.capacity];
        this.constraints = new Constraint[this.capacity];
        this.clear();
    }

    private void updateFrom(Variable variable) {
        assert (!variable.isAssigned());
        Constraint[] constraints = variable.getInvolvingConstraints();
        int j = 0;
        while (j < constraints.length) {
            if (this.propagationTechnique.admits(constraints[j])) {
                this.add(variable, constraints[j]);
            }
            ++j;
        }
    }

    public void fill() {
        Variable[] variables = this.propagationTechnique.getSolver().getVariables();
        int i = 0;
        while (i < variables.length) {
            if (!variables[i].isAssigned()) {
                this.updateFrom(variables[i]);
            }
            ++i;
        }
    }

    private void updateFrom(Constraint constraint, Variable revisedVariable) {
        Variable futureVariable = constraint.getFirstFutureVariable();
        while (futureVariable != null) {
            if (futureVariable != revisedVariable || this.propagationTechnique.isBoundConsistency()) {
                this.add(futureVariable, constraint);
            }
            futureVariable = constraint.getNextFutureVariableAfter(futureVariable);
        }
    }

    public void initAfterModificationOf(Variable variable) {
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (this.propagationTechnique.admits(constraint)) {
                this.updateFrom(constraint, variable);
            }
            ++n;
        }
    }

    public boolean pickElementAndCheckConsistency() {
        int selection = this.revisionOrderingHeuristic.getIndexOfBestPropagationElement();
        Constraint constraint = this.getConstraint(selection);
        Variable variable = this.getVariable(selection);
        this.remove(selection);
        return this.propagationTechnique.isConsistent(constraint, variable);
    }

    public void updateAfterEffectiveRevisionOf(Constraint constraint, Variable revisedVariable, int nbRemovals) {
        if (!this.propagationTechnique.isMultiPass()) {
            return;
        }
        Constraint[] constraints = revisedVariable.getInvolvingConstraints();
        int i = 0;
        while (i < constraints.length) {
            if (this.propagationTechnique.admits(constraints[i]) && (constraints[i] != constraint || this.useBackRevisions())) {
                this.updateFrom(constraints[i], revisedVariable);
            }
            ++i;
        }
    }

    private void add(Variable variable, Constraint constraint) {
        int position;
        int idElement = this.offsets[constraint.getId()] + constraint.getPositionOf(variable);
        if (this.positionOfElements[idElement] != -1) {
            return;
        }
        this.positionOfElements[idElement] = position = (this.head + this.size) % this.capacity;
        this.constraints[position] = constraint;
        this.variables[position] = variable;
        ++this.size;
    }

    public void remove(int i) {
        int position = (this.head + i) % this.capacity;
        Variable variable = this.variables[position];
        Constraint constraint = this.constraints[position];
        if (position == this.head) {
            this.head = (this.head + 1) % this.capacity;
        } else if (position != (this.head + this.size - 1) % this.capacity) {
            Constraint lastConstraint = this.getLastConstraint();
            Variable lastVariable = this.getLastVariable();
            this.constraints[position] = lastConstraint;
            this.variables[position] = lastVariable;
            this.positionOfElements[this.offsets[lastConstraint.getId()] + lastConstraint.getPositionOf((Variable)lastVariable)] = position;
        }
        this.positionOfElements[this.offsets[constraint.getId()] + constraint.getPositionOf((Variable)variable)] = -1;
        --this.size;
    }

    public void swap(int i, int j) {
        int k = (this.head + i) % this.capacity;
        int l = (this.head + j) % this.capacity;
        Variable tmpV = this.variables[k];
        Constraint tmpC = this.constraints[k];
        this.variables[k] = this.variables[l];
        this.constraints[k] = this.constraints[l];
        this.variables[l] = tmpV;
        this.constraints[l] = tmpC;
        this.positionOfElements[this.offsets[this.constraints[k].getId()] + this.constraints[k].getPositionOf((Variable)this.variables[k])] = k;
        this.positionOfElements[this.offsets[this.constraints[l].getId()] + this.constraints[l].getPositionOf((Variable)this.variables[l])] = l;
    }

    public void display() {
        super.display();
        int i = 0;
        while (i < this.size) {
            System.out.print("(" + this.getConstraint(i) + "," + this.getVariable(i) + ") ");
            ++i;
        }
        System.out.println();
    }
}

