/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.propagationSets;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSet;
import abscon.solvers.systematicSolvers.HyperNogoodManager;
import abscon.solvers.systematicSolvers.NogoodManager;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;

public class NewPropagationSet
extends PropagationSet {
    private NogoodManager nogoodManager;
    private HyperNogoodManager hyperNogoodManager;
    private boolean discardRevisionManager;
    static int cpt;

    public void setNogoodManager(NogoodManager nogoodManager) {
        this.nogoodManager = nogoodManager;
    }

    public void setHyperNogoodManager(HyperNogoodManager hyperNogoodManager) {
        this.hyperNogoodManager = hyperNogoodManager;
    }

    public void attachTo(PropagationTechnique propagationTechnique) {
        super.attachTo(propagationTechnique);
        this.capacity = propagationTechnique.getSolver().getProblem().getNbVariables();
        this.positionOfElements = new int[this.capacity];
        this.variables = new Variable[this.capacity];
        this.clear();
        this.discardRevisionManager = propagationTechnique.getSolver().getProblem().getMaxVariableDomainSize() < 4;
    }

    public void fill() {
        Variable[] variableArray = this.propagationTechnique.getSolver().getVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            this.add(variable);
            ++n;
        }
    }

    public void fillWithPastVariables() {
        Variable[] variableArray = this.propagationTechnique.getSolver().getVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            if (variable.isAssigned()) {
                this.add(variable);
            }
            ++n;
        }
    }

    public void initAfterModificationOf(Variable variable) {
        this.add(variable);
    }

    public boolean isNogoodConsistent(Variable variable) {
        boolean consistent;
        if (this.nogoodManager != null) {
            boolean consistent2;
            Elements elements = variable.getDomain().getElements();
            boolean bl = consistent2 = elements.getNbPresentElements() != 1 || this.nogoodManager.checkWatchesOf(variable, elements.getFirstPresent(), false);
            if (!consistent2) {
                return false;
            }
        }
        return this.hyperNogoodManager == null || (consistent = this.hyperNogoodManager.checkWatchesOf(variable.getId()));
    }

    public boolean pickElementAndCheckConsistency() {
        int selection = this.discardRevisionManager ? 0 : this.revisionOrderingHeuristic.getIndexOfBestPropagationElement();
        Variable variable = this.getVariable(selection);
        this.remove(selection);
        if (!this.isNogoodConsistent(variable)) {
            return false;
        }
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (!this.propagationTechnique.isConsistent(variable, constraint)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void updateAfterEffectiveRevisionOf(Constraint constraint, Variable variable, int nbRemovals) {
        if (!this.propagationTechnique.isMultiPass()) {
            return;
        }
        this.add(variable);
    }

    public void add(Variable variable) {
        int position;
        variable.incrementCounter();
        if (this.positionOfElements[variable.getId()] != -1) {
            return;
        }
        this.positionOfElements[variable.getId()] = position = (this.head + this.size) % this.capacity;
        this.variables[position] = variable;
        ++this.size;
    }

    public void addNeighboursOf(Variable variable) {
        VariableManager variableManager = this.propagationTechnique.getSolver().getVariableManager();
        Variable[] neighbours = variable.getNeighbours();
        if (neighbours != null && neighbours.length <= variableManager.getNbFutureVariables()) {
            Variable[] variableArray = neighbours;
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable neighbour = variableArray[n];
                if (!neighbour.isAssigned()) {
                    this.add(neighbour);
                }
                ++n;
            }
        } else {
            Variable var = variableManager.getFirstFutureVariable();
            while (var != null) {
                if (variable != var && variable.isNeighbourOf(var)) {
                    this.add(var);
                }
                var = variableManager.getNextFutureVariableAfter(var);
            }
        }
    }

    public void remove(int i) {
        assert (i < this.size);
        int position = (this.head + i) % this.capacity;
        Variable variable = this.variables[position];
        if (position == this.head) {
            this.head = (this.head + 1) % this.capacity;
        } else if (position != (this.head + this.size - 1) % this.capacity) {
            Variable lastVariable;
            this.variables[position] = lastVariable = this.getLastVariable();
            this.positionOfElements[lastVariable.getId()] = position;
        }
        this.positionOfElements[variable.getId()] = -1;
        --this.size;
    }

    public void display() {
        super.display();
        int i = 0;
        while (i < this.size) {
            System.out.print(this.getVariable(i) + " ");
            ++i;
        }
        System.out.println();
    }
}

