/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac.limited;

import abscon.constants.AbsconConstants;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManagerBasic;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;

public class SingletonArcConsistencyN
extends SingletonArcConsistency {
    protected void buildInferenceManager() {
        this.inferenceManager = new InferenceManagerBasic(this);
    }

    private int filteringBySACOf(Variable variable) {
        int domainSizeBefore = variable.getCurrentDomainSize();
        Elements elements = variable.getDomain().getElements();
        if (this.boundConsistency) {
            while (elements.getNbPresentElements() > 0 && !this.singletonTest(variable, elements.getFirstPresent(), AbsconConstants.MinMaxNo.MIN)) {
                variable.getDomain().removeElementAt(elements.getFirstPresent());
            }
            while (elements.getNbPresentElements() > 1 && !this.singletonTest(variable, elements.getLastPresent(), AbsconConstants.MinMaxNo.MAX)) {
                variable.getDomain().removeElementAt(elements.getLastPresent());
            }
        } else {
            int index = elements.getFirstPresent();
            while (index != -1) {
                int nextIndex = elements.getNextPresent(index);
                if (!this.singletonTest(variable, index, AbsconConstants.MinMaxNo.NO)) {
                    variable.getDomain().removeElementAt(index);
                }
                index = nextIndex;
            }
        }
        return domainSizeBefore - variable.getCurrentDomainSize();
    }

    protected boolean filterBySAC() {
        this.inferenceManager.removeInferences();
        if (this.lastVariable == null) {
            return true;
        }
        boolean modified = true;
        while (modified) {
            modified = false;
            VariableManager variableManager = this.solver.getVariableManager();
            Variable variable = variableManager.getFirstFutureVariable();
            while (variable != null) {
                if (this.lastVariable == null || variable.isNeighbourOf(this.lastVariable)) {
                    int nbRemovals = this.filteringBySACOf(variable);
                    if (nbRemovals > 0) {
                        if (variable.getCurrentDomainSize() == 0) {
                            this.culprit = variable;
                            return false;
                        }
                        modified = true;
                        if (!super.checkArcConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1)) {
                            return false;
                        }
                    }
                    if (this.solver.getResolution().isFinished()) {
                        return true;
                    }
                }
                variable = variableManager.getNextFutureVariableAfter(variable);
            }
        }
        return true;
    }
}

