/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac.limited;

import abscon.constants.AbsconConstants;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManagerBasic;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;

public class SingletonArcConsistencyFLT
extends SingletonArcConsistency {
    protected void buildInferenceManager() {
        this.inferenceManager = new InferenceManagerBasic(this);
    }

    private boolean reestablishAC(Variable variable) {
        if (variable.getCurrentDomainSize() == 0) {
            this.culprit = variable;
            return false;
        }
        return super.checkArcConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1);
    }

    private boolean filteringFirstSACOf(Variable variable) {
        int domainSizeBefore = variable.getCurrentDomainSize();
        Elements elements = variable.getDomain().getElements();
        while (elements.getNbPresentElements() > 0 && !this.singletonTest(variable, elements.getFirstPresent(), AbsconConstants.MinMaxNo.MIN)) {
            variable.getDomain().removeElementAt(elements.getFirstPresent());
            if (this.reestablishAC(variable)) continue;
            return false;
        }
        while (elements.getNbPresentElements() > 1 && !this.singletonTest(variable, elements.getLastPresent(), AbsconConstants.MinMaxNo.MAX)) {
            variable.getDomain().removeElementAt(elements.getLastPresent());
            if (this.reestablishAC(variable)) continue;
            return false;
        }
        return true;
    }

    protected boolean filterBySAC() {
        this.inferenceManager.removeInferences();
        boolean modified = true;
        while (modified) {
            modified = false;
            VariableManager variableManager = this.solver.getVariableManager();
            Variable variable = variableManager.getFirstFutureVariable();
            while (variable != null) {
                if (variable.getId() < 7) {
                    int domainSizeBefore = variable.getCurrentDomainSize();
                    if (!this.filteringFirstSACOf(variable)) {
                        return false;
                    }
                    int nbRemovals = domainSizeBefore - variable.getCurrentDomainSize();
                    if (nbRemovals > 0) {
                        modified = true;
                    }
                }
                variable = variableManager.getNextFutureVariableAfter(variable);
            }
        }
        return true;
    }
}

