/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac.limited;

import abscon.constants.AbsconConstants;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManagerBoundFull;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.inferenceUnits.InferenceUnit;
import abscon.propagationTechniques.propagationSets.PropagationSetOfRemovals;
import abscon.solvers.Solver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;

public class SingletonArcConsistencyFLSDS
extends SingletonArcConsistency {
    protected PropagationSetOfRemovals queue;
    protected boolean mustMaintainAC = true;
    protected int[] sizes;

    protected void buildInferenceManager() {
        if (this.boundConsistency) {
            throw new IncompatiblePropertiesException();
        }
        this.inferenceManager = new InferenceManagerBoundFull(this);
    }

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        this.queue = new PropagationSetOfRemovals();
        this.queue.attachTo(this);
        if (this.mustMaintainAC) {
            this.sizes = new int[solver.getNbVariables()];
        }
    }

    public void recordNogood(Variable variable1, int index1, Variable variable2, int index2) {
        InferenceManagerBoundFull im = (InferenceManagerBoundFull)this.inferenceManager;
        int bound = im.whichBound(variable1, index1);
        if (bound == -1) {
            this.queue.add(variable1, index1);
        } else {
            InferenceUnit rule = this.inferenceManager.getInferenceUnit(variable1, bound, variable2);
            if (!rule.isAbsent(index2)) {
                rule.addAbsent(index2);
                this.queue.add(variable1, index1);
            }
        }
    }

    protected void updateQueueAfterRemovalOf(Variable variable, int index) {
        InferenceManagerBoundFull im = (InferenceManagerBoundFull)this.inferenceManager;
        VariableManager variableManager = this.solver.getVariableManager();
        Variable fvariable = variableManager.getFirstFutureVariable();
        while (fvariable != null) {
            Elements elements = fvariable.getDomain().getElements();
            int first = elements.getFirstPresent();
            this.recordNogood(fvariable, first, variable, index);
            int last = elements.getLastPresent();
            if (last != first) {
                this.recordNogood(fvariable, last, variable, index);
            }
            fvariable = variableManager.getNextFutureVariableAfter(fvariable);
        }
    }

    protected boolean reestablishAC(Variable variable) {
        Variable[] variables = this.solver.getVariables();
        int i = 0;
        while (i < this.sizes.length) {
            this.sizes[i] = variables[i].getCurrentDomainSize();
            ++i;
        }
        this.propagationSet.initAfterModificationOf(variable);
        boolean consistent = this.checkConsistencyOfPropagationSet();
        if (!consistent) {
            this.queue.clear();
            return false;
        }
        int i2 = 0;
        while (i2 < this.sizes.length) {
            int nbRemovals = this.sizes[i2] - variables[i2].getCurrentDomainSize();
            if (nbRemovals > 0) {
                Elements elements = variables[i2].getDomain().getElements();
                int j = 0;
                int currentIndex = elements.getLastAbsent();
                while (j < nbRemovals) {
                    this.updateQueueAfterRemovalOf(variables[i2], currentIndex);
                    ++j;
                    currentIndex = elements.getPrevAbsent(currentIndex);
                }
            }
            ++i2;
        }
        return true;
    }

    protected AbsconConstants.MinMaxNo getMode(Variable variable, int index) {
        if (variable.getDomain().getFirstValidIndex() == index) {
            return AbsconConstants.MinMaxNo.MIN;
        }
        if (variable.getDomain().getLastValidIndex() == index) {
            return AbsconConstants.MinMaxNo.MAX;
        }
        throw new UnreachableCodeException();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        this.lastVariable = variable;
        int depth = this.solver.getCurrentDepth();
        Elements elements = variable.getDomain().getElements();
        int currentIndex = elements.getLastAbsent();
        while (currentIndex != -1) {
            if (elements.getAbsentLevelOf(currentIndex) < depth) break;
            this.updateQueueAfterRemovalOf(variable, currentIndex);
            currentIndex = elements.getPrevAbsent(currentIndex);
        }
        if (!this.reestablishAC(variable)) {
            return false;
        }
        return this.filterQueue();
    }

    protected boolean filterQueue() {
        while (this.queue.size() > 0) {
            Variable variable = this.queue.getLastVariable();
            int index = this.queue.getLastIndex();
            this.queue.removeLastElement();
            if (!variable.getDomain().hasIndex(index)) continue;
            assert (!variable.isAssigned() && variable.getDomain().hasIndex(index) && this.propagationSet.controlClear());
            AbsconConstants.MinMaxNo mode = this.getMode(variable, index);
            if (!this.singletonTest(variable, index, mode)) {
                variable.getDomain().removeElementAt(index);
                if (variable.getCurrentDomainSize() == 0) {
                    this.queue.clear();
                    this.culprit = variable;
                    return false;
                }
                this.updateQueueAfterRemovalOf(variable, index);
                if (this.mustMaintainAC && !this.reestablishAC(variable)) {
                    return false;
                }
            }
            if (!this.solver.getResolution().isFinished()) continue;
            this.queue.clear();
            return true;
        }
        assert (this.controlConsistency(false));
        assert (this.solver.getResolution().isFinished() || this.controlSingletonArcConsistency(true));
        return true;
    }

    protected boolean filterBySAC() {
        assert (this.propagationSet.controlClear());
        this.inferenceManager.removeInferences();
        this.queue.fillWithBounds();
        return this.filterQueue();
    }
}

