/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac;

import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.ArcConsistency;
import abscon.propagationTechniques.supportManagers.SupportManager2003;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.BoundedElements;
import abscon.tools.elements.Elements;

public class SingletonArcConsistencyD
extends ArcConsistency {
    protected long nbIntervalTests;
    private int divisor;
    private boolean[] sacDone;

    public void attachTo(SystematicSolver solver) {
        super.attachTo(solver);
        if (this.supportManager instanceof SupportManager2003) {
            throw new IncompatiblePropertiesException();
        }
        if (solver.getBacktrackingMode() != 10) {
            throw new IncompatiblePropertiesException();
        }
    }

    public void initializeBeforeRun() {
        super.initializeBeforeRun();
        this.nbIntervalTests = 0L;
        this.sacDone = new boolean[this.solver.getNbVariables()];
        int i = 0;
        while (i < this.sacDone.length) {
            this.sacDone[i] = false;
            ++i;
        }
    }

    protected boolean dichotomicTest(Variable futureVariable, int min, int max, IntervalPart part, int level) {
        int testMax;
        int testMin;
        int nbElements = max - min + 1;
        if (nbElements <= 1) {
            return true;
        }
        int half = 1 < nbElements && nbElements < this.divisor ? 1 : (int)Math.floor((double)nbElements / (double)this.divisor);
        if (part == IntervalPart.INF) {
            testMin = min;
            testMax = min + half - 1;
        } else {
            testMin = max - half + 1;
            testMax = max;
        }
        if (testMax < futureVariable.getDomain().getFirstValidIndex()) {
            return true;
        }
        if (testMin > futureVariable.getDomain().getLastValidIndex()) {
            return true;
        }
        if (!this.intervalTest(futureVariable, testMin, testMax, level + 1)) {
            if (!this.remove(futureVariable, testMin, testMax, level)) {
                return false;
            }
            if (part == IntervalPart.INF) {
                return this.dichotomicTest(futureVariable, testMax + 1, max, IntervalPart.INF, level);
            }
            return this.dichotomicTest(futureVariable, min, testMin - 1, IntervalPart.SUP, level);
        }
        return this.dichotomicTest(futureVariable, testMin, testMax, part, level);
    }

    private boolean remove(Variable variable, int min, int max, int level) {
        ((BoundedElements)variable.getDomain().getElements()).remove(min, max, level);
        this.propagationSet.initAfterModificationOf(variable);
        return this.checkConsistencyOfPropagationSet();
    }

    private boolean dichotomicTest(Variable variable, IntervalPart part, int level) {
        return this.dichotomicTest(variable, variable.getDomain().getFirstValidIndex(), variable.getDomain().getLastValidIndex(), part, level);
    }

    private boolean intervalTest(Variable futureVariable, int min, int max, int level) {
        ((BoundedElements)futureVariable.getDomain().getElements()).reduceTo(min, max, level);
        ((SystematicSolver)this.solver).setDepth(level);
        this.propagationSet.initAfterModificationOf(futureVariable);
        boolean consistent = this.checkConsistencyOfPropagationSet();
        assert (!consistent || this.controlConsistency(false));
        ((SystematicSolver)this.solver).unSetDepth();
        this.solver.undoPropagationOf(futureVariable);
        ++this.nbIntervalTests;
        return consistent;
    }

    protected boolean filterBySAC() {
        boolean change;
        this.divisor = 2;
        int level = this.solver.getCurrentDepth();
        do {
            change = false;
            VariableManager variableManager = this.solver.getVariableManager();
            Variable variable = variableManager.getFirstFutureVariable();
            while (variable != null) {
                if (!this.intervalTest(variable, variable.getDomain().getFirstValidIndex(), variable.getDomain().getFirstValidIndex(), level + 1)) {
                    if (!this.remove(variable, variable.getDomain().getFirstValidIndex(), variable.getDomain().getFirstValidIndex(), level)) {
                        return false;
                    }
                    if (!this.dichotomicTest(variable, IntervalPart.INF, level)) {
                        return false;
                    }
                    change = true;
                }
                if (!this.intervalTest(variable, variable.getDomain().getLastValidIndex(), variable.getDomain().getLastValidIndex(), level + 1)) {
                    if (!this.remove(variable, variable.getDomain().getLastValidIndex(), variable.getDomain().getLastValidIndex(), level)) {
                        return false;
                    }
                    if (!this.dichotomicTest(variable, IntervalPart.SUP, level)) {
                        return false;
                    }
                    change = true;
                }
                variable = variableManager.getNextFutureVariableAfter(variable);
            }
        } while (change);
        return true;
    }

    public boolean checkConsistency() {
        return super.checkConsistency() && this.filterBySAC();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        return super.checkConsistencyAfterAssignmentOf(variable) && this.filterBySAC();
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        return super.checkConsistencyAfterRefutationOf(variable, variableDepth) && this.filterBySAC();
    }

    protected boolean checkArcConsistencyAfterUnassignmentOf(Variable variable, int variableDepth) {
        return super.checkConsistencyAfterRefutationOf(variable, variableDepth);
    }

    private boolean controlSingleton(Variable futureVariable, int index) {
        this.solver.doAssignment(futureVariable, index);
        this.propagationSet.initAfterModificationOf(futureVariable);
        boolean consistent = this.checkConsistencyOfPropagationSet();
        this.solver.undoAssignmentOf(futureVariable);
        ((SystematicSolver)this.solver).undoPropagationOf(futureVariable);
        this.supportManager.restoreSupportsOfFutureVariables(this.solver.getCurrentDepth());
        return consistent;
    }

    protected boolean controlSingletonArcConsistency() {
        VariableManager variableManager = ((SystematicSolver)this.solver).getVariableManager();
        Variable futureVariable = variableManager.getFirstFutureVariable();
        while (futureVariable != null) {
            Elements elements = futureVariable.getDomain().getElements();
            if (this.boundConsistency) {
                if (!this.controlSingleton(futureVariable, elements.getFirstPresent())) {
                    return false;
                }
                if (!this.controlSingleton(futureVariable, elements.getLastPresent())) {
                    return false;
                }
            } else {
                int index = elements.getFirstPresent();
                while (index != -1) {
                    if (!this.controlSingleton(futureVariable, index)) {
                        return false;
                    }
                    index = elements.getNextPresent(index);
                }
            }
            futureVariable = variableManager.getNextFutureVariableAfter(futureVariable);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IntervalPart {
        INF,
        SUP;

    }
}

