/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac;

import abscon.constants.AbsconConstants;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistencySDS;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManagerBound2;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.inferenceUnits.InferenceUnitBound;
import abscon.tools.elements.BoundedElements;

public class SingletonArcConsistency2B
extends SingletonArcConsistencySDS {
    protected void buildInferenceManager() {
        if (!this.boundConsistency) {
            throw new IncompatiblePropertiesException();
        }
        this.inferenceManager = new InferenceManagerBound2(this);
    }

    protected void updateQueueAfterRemovalOf(Variable variable, int index) {
        assert (index < variable.getDomain().getElements().getFirstPresent() || index > variable.getDomain().getElements().getLastPresent());
        if (index < variable.getDomain().getElements().getFirstPresent()) {
            this.queue.add(variable, variable.getDomain().getElements().getFirstPresent());
        } else {
            this.queue.add(variable, variable.getDomain().getElements().getLastPresent());
        }
        Variable[] variables = this.solver.getVariables();
        int i = 0;
        while (i < variables.length) {
            if (!variables[i].isAssigned() && variables[i] != variable) {
                InferenceUnitBound rule = (InferenceUnitBound)this.inferenceManager.getInferenceUnit(variables[i], 0, variable);
                if (variables[i].getDomain().getElements().getFirstPresent() == rule.getBoundAssigned() && !rule.isAbsent(index)) {
                    rule.addAbsent(index);
                    this.queue.add(variables[i], variables[i].getDomain().getElements().getFirstPresent());
                }
                rule = (InferenceUnitBound)this.inferenceManager.getInferenceUnit(variables[i], 1, variable);
                if (variables[i].getDomain().getElements().getLastPresent() == rule.getBoundAssigned() && !rule.isAbsent(index)) {
                    rule.addAbsent(index);
                    this.queue.add(variables[i], variables[i].getDomain().getElements().getLastPresent());
                }
            }
            ++i;
        }
    }

    protected boolean reestablishAC(Variable variable) {
        if (this.solver.getVariable(0).getDomain().getElements() instanceof BoundedElements) {
            Variable[] variables = this.solver.getVariables();
            int i = 0;
            while (i < variables.length) {
                ((BoundedElements)this.solver.getVariable(i).getDomain().getElements()).store(this.solver.getCurrentDepth());
                ++i;
            }
            this.propagationSet.initAfterModificationOf(variable);
            boolean consistent = this.checkConsistencyOfPropagationSet();
            if (!consistent) {
                this.queue.clear();
                return false;
            }
            int i2 = 0;
            while (i2 < variables.length) {
                Variable currentVariable = this.solver.getVariable(i2);
                BoundedElements elements = (BoundedElements)this.solver.getVariable(i2).getDomain().getElements();
                int nbRemovals = elements.getNbAbsentElementsSinceStorage();
                if (nbRemovals > 0) {
                    BoundedElements.Interval interval1 = elements.getMinIntervalFromStorage();
                    int ind = interval1.min;
                    while (ind < interval1.max) {
                        this.updateQueueAfterRemovalOf(currentVariable, ind);
                        ++ind;
                    }
                    BoundedElements.Interval interval2 = elements.getMaxIntervalFromStorage();
                    int ind2 = interval2.min + 1;
                    while (ind2 <= interval2.max) {
                        this.updateQueueAfterRemovalOf(currentVariable, ind2);
                        ++ind2;
                    }
                }
                ++i2;
            }
        } else if (!super.reestablishAC(variable)) {
            return false;
        }
        return true;
    }

    protected AbsconConstants.MinMaxNo getMode(Variable variable, int index) {
        assert (index == variable.getDomain().getElements().getFirstPresent() || index == variable.getDomain().getElements().getLastPresent());
        if (index == variable.getDomain().getElements().getFirstPresent()) {
            return AbsconConstants.MinMaxNo.MIN;
        }
        return AbsconConstants.MinMaxNo.MAX;
    }
}

