/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac;

import abscon.constants.AbsconConstants;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManager;
import abscon.propagationTechniques.supportManagers.SupportManager2003;
import abscon.solvers.Solver;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;

public abstract class SingletonArcConsistency
extends ArcConsistency {
    protected InferenceManager inferenceManager;
    protected long nbSingletonTests;
    protected long nbEffectiveSingletonTests;
    protected Variable lastVariable;
    private boolean control = false;

    public long getNbSingletonTests() {
        return this.nbSingletonTests;
    }

    public long getNbEffectiveSingletonTests() {
        return this.nbEffectiveSingletonTests;
    }

    protected abstract void buildInferenceManager();

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        if (this.supportManager instanceof SupportManager2003) {
            throw new IncompatiblePropertiesException();
        }
        if (solver instanceof SystematicSolver && ((SystematicSolver)solver).getBacktrackingMode() != 10) {
            throw new IncompatiblePropertiesException();
        }
        this.buildInferenceManager();
        this.pathExtension = false;
    }

    public void initializeBeforeRun() {
        super.initializeBeforeRun();
        this.nbSingletonTests = 0L;
        this.nbEffectiveSingletonTests = 0L;
    }

    protected boolean singletonTest(Variable futureVariable, int index, AbsconConstants.MinMaxNo mode) {
        if (this.boundConsistency && !futureVariable.checkBackwardConsistencyOf(index)) {
            return false;
        }
        ++this.nbSingletonTests;
        this.solver.doAssignment(futureVariable, index);
        boolean consistent = this.inferenceManager.exploitInferences(futureVariable, index);
        if (consistent) {
            consistent = this.checkConsistencyOfPropagationSet();
            assert (!consistent || this.controlConsistency(false)) : "problem after singleton test: " + futureVariable + " = " + index;
            if (consistent) {
                this.inferenceManager.updateInferences(futureVariable, index, mode);
            } else {
                ++this.nbEffectiveSingletonTests;
            }
        }
        this.solver.undoAssignmentOf(futureVariable);
        ((SystematicSolver)this.solver).undoPropagationOf(futureVariable);
        this.supportManager.restoreSupportsOfFutureVariables(this.solver.getCurrentDepth());
        return consistent;
    }

    protected abstract boolean filterBySAC();

    public boolean checkConsistency() {
        Domain.resetNbRemovals();
        if (!super.checkConsistency()) {
            return false;
        }
        return !this.control || Domain.getNbRemovals() > 0 ? this.filterBySAC() : true;
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        Domain.resetNbRemovals();
        this.lastVariable = variable;
        if (!this.inferenceManager.exploitInferences(variable, variable.getDomain().getUniqueIndex())) {
            return false;
        }
        if (!super.checkConsistencyAfterAssignmentOf(variable)) {
            return false;
        }
        return !this.control || Domain.getNbRemovals() > 0 ? this.filterBySAC() : true;
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        Domain.resetNbRemovals();
        this.lastVariable = variable;
        this.inferenceManager.removeInferences();
        if (!super.checkConsistencyAfterRefutationOf(variable, variableDepth)) {
            return false;
        }
        return !this.control || Domain.getNbRemovals() > 0 ? this.filterBySAC() : true;
    }

    protected boolean checkArcConsistency() {
        return super.checkConsistency();
    }

    protected boolean checkArcConsistencyAfterAssignmentOf(Variable variable) {
        return super.checkConsistencyAfterAssignmentOf(variable);
    }

    protected boolean checkArcConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        return super.checkConsistencyAfterRefutationOf(variable, variableDepth);
    }

    protected void displaySimilarValues(Variable variable, int index) {
        VariableManager variableManager = ((SystematicSolver)this.solver).getVariableManager();
        Variable futureVariable = variableManager.getFirstFutureVariable();
        while (futureVariable != null) {
            if (futureVariable.getCurrentDomainSize() == 1) {
                System.out.println("similar value to (" + variable + "," + index + ") = (" + futureVariable + "," + futureVariable.getDomain().getFirstValidIndex() + ")");
            }
            futureVariable = variableManager.getNextFutureVariableAfter(futureVariable);
        }
    }

    private boolean controlSingleton(Variable futureVariable, int index) {
        this.solver.doAssignment(futureVariable, index);
        this.propagationSet.initAfterModificationOf(futureVariable);
        boolean consistent = this.checkConsistencyOfPropagationSet();
        this.solver.undoAssignmentOf(futureVariable);
        ((SystematicSolver)this.solver).undoPropagationOf(futureVariable);
        this.supportManager.restoreSupportsOfFutureVariables(this.solver.getCurrentDepth());
        return consistent;
    }

    protected boolean controlSingletonArcConsistency() {
        return this.controlSingletonArcConsistency(this.boundConsistency);
    }

    protected boolean controlSingletonArcConsistency(boolean b) {
        VariableManager variableManager = ((SystematicSolver)this.solver).getVariableManager();
        Variable futureVariable = variableManager.getFirstFutureVariable();
        while (futureVariable != null) {
            Elements elements = futureVariable.getDomain().getElements();
            if (b) {
                if (!this.controlSingleton(futureVariable, elements.getFirstPresent())) {
                    System.out.println(futureVariable + " " + elements.getFirstPresent() + " not first singleton consistent");
                    return false;
                }
                if (!this.controlSingleton(futureVariable, elements.getLastPresent())) {
                    System.out.println(futureVariable + " " + elements.getLastPresent() + " not last singleton consistent");
                    return false;
                }
            } else {
                int index = elements.getFirstPresent();
                while (index != -1) {
                    if (!this.controlSingleton(futureVariable, index)) {
                        System.out.println(futureVariable + " " + index + " not singleton consistent");
                        return false;
                    }
                    index = elements.getNextPresent(index);
                }
            }
            futureVariable = variableManager.getNextFutureVariableAfter(futureVariable);
        }
        return true;
    }
}

