/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac;

import abscon.constants.AbsconConstants;
import abscon.constraints.Constraint;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ArcConsistency;
import abscon.solvers.Solver;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.elements.Elements;

public class SPACE
extends ArcConsistency {
    private boolean maintainAC = false;
    protected long nbSingletonTests;
    protected long nbEffectiveSingletonTests;
    protected Variable lastVariable;
    int cptSAC;
    int cptPC;
    Variable lastEffectiveVariable;
    int lastEffectiveIndex;

    public boolean guaranteeConsistencyOfValueSingletons() {
        return false;
    }

    public long getNbSingletonTests() {
        return this.nbSingletonTests;
    }

    public long getNbEffectiveSingletonTests() {
        return this.nbEffectiveSingletonTests;
    }

    public void attachTo(Solver solver) {
        super.attachTo(solver);
    }

    public void initializeBeforeRun() {
        super.initializeBeforeRun();
        this.nbSingletonTests = 0L;
        this.nbEffectiveSingletonTests = 0L;
    }

    private void removeTuplesFor(Variable variable, int index) {
        int cptPCBefore = this.cptPC;
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            int[] tmp = constraint.getTupleManager().getLocalTuple();
            int variablePosition = constraint.getPositionOf(variable);
            int brotherPosition = variablePosition == 0 ? 1 : 0;
            Variable brotherVariable = constraint.getInvolvedVariable(brotherPosition);
            tmp[variablePosition] = index;
            Elements elements = brotherVariable.getDomain().getElements();
            int currentIndex = elements.getLastAbsent();
            while (currentIndex != -1) {
                tmp[brotherPosition] = currentIndex;
                if (!constraint.removeTuple(tmp)) break;
                ++this.cptPC;
                currentIndex = elements.getPrevAbsent(currentIndex);
            }
            ++n;
        }
        if (cptPCBefore != this.cptPC) {
            this.lastEffectiveVariable = variable;
            this.lastEffectiveIndex = index;
        }
    }

    protected boolean singletonTest(Variable futureVariable, int index, AbsconConstants.MinMaxNo mode) {
        ++this.nbSingletonTests;
        this.solver.doAssignment(futureVariable, index);
        boolean consistent = super.checkConsistencyAfterAssignmentOf(futureVariable);
        assert (!consistent || this.controlConsistency(false)) : "problem after singleton test: " + futureVariable + " = " + index;
        if (consistent) {
            this.removeTuplesFor(futureVariable, index);
        } else {
            ++this.nbEffectiveSingletonTests;
            this.lastEffectiveVariable = futureVariable;
            this.lastEffectiveIndex = index;
        }
        this.solver.undoAssignmentOf(futureVariable);
        ((SystematicSolver)this.solver).undoPropagationOf(futureVariable);
        return consistent;
    }

    private int filteringBySACOf(Variable variable) {
        boolean testFixpoint = this.lastEffectiveVariable == variable;
        int domainSizeBefore = variable.getCurrentDomainSize();
        Elements elements = variable.getDomain().getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            int nextIndex = elements.getNextPresent(index);
            if (testFixpoint && index >= this.lastEffectiveIndex) {
                return -2;
            }
            if (!this.singletonTest(variable, index, AbsconConstants.MinMaxNo.NO)) {
                variable.getDomain().removeElementAt(index);
                ++this.cptSAC;
                if (this.maintainAC && elements.getNbPresentElements() > 0 && !super.checkConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1)) {
                    return -1;
                }
            }
            index = nextIndex;
        }
        return domainSizeBefore - variable.getCurrentDomainSize();
    }

    public boolean establishOnePass() {
        boolean modified = true;
        while (modified) {
            int cptAC = 0;
            this.cptSAC = 0;
            this.cptPC = 0;
            Variable[] variableArray = this.solver.getVariables();
            int n = 0;
            int n2 = variableArray.length;
            while (n < n2) {
                Variable variable = variableArray[n];
                int nbRemovals = this.filteringBySACOf(variable);
                if (nbRemovals == -2) break;
                if (nbRemovals == -1) {
                    return false;
                }
                if (nbRemovals > 0) {
                    if (variable.getCurrentDomainSize() == 0) {
                        this.culprit = variable;
                        return false;
                    }
                    modified = true;
                    Domain.resetNbRemovals();
                    if (!this.maintainAC && !super.checkConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1)) {
                        return false;
                    }
                    cptAC += Domain.getNbRemovals();
                }
                if (this.solver.getResolution().isFinished()) {
                    return true;
                }
                ++n;
            }
            modified = this.cptSAC > 0 || this.cptPC > 0;
            System.out.println(" cptAC = " + this.cptSAC + " cptPC = " + this.cptPC + " AC = " + cptAC);
        }
        return true;
    }

    public boolean checkConsistency() {
        Domain.resetNbRemovals();
        if (!super.checkConsistency()) {
            return false;
        }
        System.out.println(" AC : " + Domain.getNbRemovals() + " removals");
        return this.establishOnePass();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        throw new UnreachableCodeException();
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        throw new UnreachableCodeException();
    }
}

