/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.sac;

import abscon.Resolution;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.Branch;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.SingletonArcConsistency;
import abscon.propagationTechniques.forwardPropagationTechniques.sac.inferenceManagers.InferenceManagerBasic;
import abscon.solvers.Solver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.math.CompositionMaker;
import abscon.xml.OutputManager;

public class CopyOfSingletonArcConsistency3Single
extends SingletonArcConsistency {
    private Branch branch;
    private boolean maximumBranchExtension = false;
    protected int nbBuiltBranches;
    protected int cumulBranchSizes;
    private int nbUntestedVariables;
    private boolean[] untestedVariables;
    private Variable lastFailedVariable;
    private int lastFailedIndex;
    private boolean lastBranchWasInference;
    private int selectionMode = -1;

    public int getNbBuiltBranches() {
        return this.nbBuiltBranches;
    }

    private void setUntested(int position, boolean b) {
        if (this.untestedVariables[position] != b) {
            this.untestedVariables[position] = b;
            this.nbUntestedVariables += b ? 1 : -1;
        }
        assert (this.controlUntested());
    }

    protected void buildInferenceManager() {
        this.inferenceManager = new InferenceManagerBasic(this);
        this.branch = new Branch(this.solver);
    }

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        this.untestedVariables = new boolean[solver.getNbVariables()];
    }

    private void initialize() {
        Variable[] variables = this.solver.getVariables();
        int i = 0;
        while (i < this.untestedVariables.length) {
            this.untestedVariables[i] = variables[i].isFuture();
            ++i;
        }
        this.nbUntestedVariables = this.solver.getVariableManager().getNbFutureVariables();
        this.lastFailedVariable = null;
        assert (this.controlUntested());
    }

    protected void undoAssignmentsFromBranch(Branch branch) {
        int i = branch.getCurrentSize() - 1;
        while (i >= 0) {
            this.solver.undoAssignmentOf(branch.getVariable(i));
            this.solver.undoPropagationOf(branch.getVariable(i));
            --i;
        }
        this.supportManager.restoreSupportsOfFutureVariables(this.solver.getCurrentDepth());
    }

    protected boolean manageInconsistentAssignment(Variable variable, int index) {
        ++this.nbEffectiveSingletonTests;
        variable.getDomain().removeElementAt(index);
        if (variable.getCurrentDomainSize() == 0) {
            this.culprit = variable;
            return false;
        }
        assert (this.propagationSet.controlClear());
        if (!super.checkArcConsistencyAfterRefutationOf(variable, this.solver.getCurrentDepth() + 1)) {
            return false;
        }
        this.initialize();
        return true;
    }

    protected boolean canTryAnotherExtensionInsteadOf(Variable variable, int index) {
        if (!this.maximumBranchExtension || this.branch.getCurrentSize() == 0) {
            return false;
        }
        this.supportManager.restoreSupportsOfFutureVariables(this.solver.getCurrentDepth());
        variable.getDomain().removeElementAt(index);
        if (variable.getCurrentDomainSize() == 0) {
            return false;
        }
        this.propagationSet.initAfterModificationOf(variable);
        boolean b = this.checkConsistencyOfPropagationSet();
        return b;
    }

    protected void dealWithNewBranch(Branch branch) {
        this.undoAssignmentsFromBranch(branch);
        this.cumulBranchSizes += branch.getCurrentSize();
        ++this.nbBuiltBranches;
    }

    private Variable selectNextVariable(boolean onlyUntested) {
        Variable bestVariable = null;
        double bestResult = -9.223372036854776E18;
        VariableManager variableManager = this.solver.getVariableManager();
        Variable future = variableManager.getFirstFutureVariable();
        while (future != null) {
            if (!onlyUntested || this.untestedVariables[future.getId()]) {
                assert (!onlyUntested || !this.branch.has(future));
                double result = 0.0;
                result = this.selectionMode == 0 ? (double)(-future.getDomain().getCurrentSize()) : (this.selectionMode == 1 ? -CompositionMaker.maxMinD(future.getDomain().getCurrentSize(), future.getDynamicDegree(), this.solver.getProblem().getMaxVariableDegree()) : (double)future.getWeightedDegree() / (double)future.getDomain().getCurrentSize());
                if (result > bestResult) {
                    bestVariable = future;
                    bestResult = result;
                }
            }
            future = variableManager.getNextFutureVariableAfter(future);
        }
        assert (bestVariable != null) : "onlyUntested = " + onlyUntested;
        return bestVariable;
    }

    protected boolean buildBranch(Branch branch) {
        branch.clear();
        this.selectionMode = (this.selectionMode + 1) % 3;
        boolean finished = false;
        while (!finished) {
            Variable variable = this.lastFailedVariable != null ? this.lastFailedVariable : this.selectNextVariable(this.nbUntestedVariables > 0);
            int index = this.lastFailedVariable != null ? this.lastFailedIndex : variable.getDomain().getFirstValidIndex();
            this.lastFailedVariable = null;
            assert (!variable.isAssigned());
            assert (variable.getDomain().hasIndex(index));
            assert (this.propagationSet.controlClear());
            ++this.nbSingletonTests;
            this.solver.doAssignment(variable, index);
            this.propagationSet.initAfterModificationOf(variable);
            boolean consistent = this.checkConsistencyOfPropagationSet();
            if (consistent) {
                this.setUntested(variable.getId(), false);
                if (this.solver.getCurrentDepth() == this.solver.getNbVariables()) {
                    this.solver.dealWithNewSolution();
                    finished = true;
                    continue;
                }
                branch.add(variable, index);
                continue;
            }
            this.solver.undoAssignmentOf(variable);
            this.solver.undoPropagationOf(variable);
            if (branch.getCurrentSize() == 0) {
                return this.manageInconsistentAssignment(variable, index);
            }
            boolean bl = finished = !this.canTryAnotherExtensionInsteadOf(variable, index);
            if (!finished) continue;
            this.lastFailedVariable = variable;
            this.lastFailedIndex = index;
        }
        this.dealWithNewBranch(branch);
        return true;
    }

    protected boolean filterBySAC() {
        this.inferenceManager.removeInferences();
        this.nbBuiltBranches = 0;
        this.cumulBranchSizes = 0;
        this.initialize();
        while (this.nbUntestedVariables > 0) {
            boolean consistent = this.buildBranch(this.branch);
            if (!consistent) {
                return false;
            }
            if (this.solver.getResolution().isFinished()) {
                return true;
            }
            if (this.nbBuiltBranches <= 1 || !((double)Resolution.getResolutionStopwatch().getCurrentCpuTime() / 1000.0 > 20.0) || this.lastBranchWasInference) continue;
            System.out.println(String.valueOf(OutputManager.COMMENT_PREFIX) + "stopping ESAC");
            break;
        }
        return true;
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        return this.checkArcConsistencyAfterAssignmentOf(variable);
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        return this.checkArcConsistencyAfterRefutationOf(variable, variableDepth);
    }

    private boolean controlUntested() {
        int cpt = 0;
        int i = 0;
        while (i < this.untestedVariables.length) {
            if (this.untestedVariables[i]) {
                if (!this.solver.getVariable(i).isFuture()) {
                    return false;
                }
                ++cpt;
            }
            ++i;
        }
        return cpt == this.nbUntestedVariables;
    }
}

