/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.maxCSP;

import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.maxCSP.MaxCSP;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;

public class SingletonMaxCSP
extends MaxCSP {
    private int nbSingletonTests;
    private int nbEffectiveSingletonTests;

    protected boolean singletonTest(Variable futureVariable, int index) {
        ++this.nbSingletonTests;
        this.solver.doAssignment(futureVariable, index);
        boolean consistent = super.checkConsistencyAfterAssignmentOf(futureVariable);
        if (!consistent) {
            ++this.nbEffectiveSingletonTests;
        }
        this.solver.undoAssignmentOf(futureVariable);
        ((SystematicSolver)this.solver).undoPropagationOf(futureVariable);
        return consistent;
    }

    private int filteringBySACOf(Variable variable) {
        int domainSizeBefore = variable.getCurrentDomainSize();
        Elements elements = variable.getDomain().getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            int nextIndex = elements.getNextPresent(index);
            if (!this.singletonTest(variable, index)) {
                variable.getDomain().removeElementAt(index);
            }
            index = nextIndex;
        }
        return domainSizeBefore - variable.getCurrentDomainSize();
    }

    protected boolean filterBySAC() {
        VariableManager variableManager = this.solver.getVariableManager();
        if (variableManager.getNbFutureVariables() == 0) {
            return true;
        }
        Variable variable = variableManager.getFirstFutureVariable();
        while (variable != null) {
            int nbRemovals = this.filteringBySACOf(variable);
            if (nbRemovals > 0 && variable.getCurrentDomainSize() == 0) {
                return false;
            }
            variable = variableManager.getNextFutureVariableAfter(variable);
        }
        if (!super.checkConsistencyAfterRefutationOf(null, this.solver.getCurrentDepth() + 1)) {
            return false;
        }
        if (this.solver.getResolution().isFinished()) {
            return true;
        }
        return true;
    }

    public boolean checkConsistency() {
        this.increment = true;
        if (!super.checkConsistency()) {
            return false;
        }
        this.increment = false;
        return this.filterBySAC();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        this.increment = true;
        if (!super.checkConsistencyAfterAssignmentOf(variable)) {
            return false;
        }
        this.increment = false;
        return this.filterBySAC();
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        this.increment = true;
        if (!super.checkConsistencyAfterRefutationOf(variable, variableDepth)) {
            return false;
        }
        this.increment = false;
        return this.filterBySAC();
    }
}

