/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.maxCSP;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.solvers.Solver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public class MaxCSPBasic
extends ForwardPropagationTechnique {
    private boolean[][][] cost;
    private int[] inactive;
    private int turn;
    private int upperBound;
    private int nbViolatedPastConstraints;
    private int nbActiveFutureConstraints;
    private int nbActiveConstraints;
    private int[][] mnis;
    private int[] mni;
    private int sumMni;

    public void attachTo(Solver solver) {
        if (solver.getProblem().getNbUnaryConstraints() > 0) {
            throw new IncompatiblePropertiesException();
        }
        super.attachTo(solver);
        Constraint[] constraints = solver.getConstraints();
        this.cost = new boolean[constraints.length][][];
        this.inactive = new int[constraints.length];
        int i = 0;
        while (i < this.cost.length) {
            Variable[] involvedVariables = constraints[i].getInvolvedVariables();
            this.cost[i] = new boolean[involvedVariables.length][];
            int j = 0;
            while (j < this.cost[i].length) {
                this.cost[i][j] = new boolean[involvedVariables[j].getDomain().getMaximumSize()];
                ++j;
            }
            ++i;
        }
        Variable[] variables = solver.getVariables();
        this.mni = new int[variables.length];
        this.mnis = new int[variables.length][];
        int i2 = 0;
        while (i2 < this.mnis.length) {
            this.mnis[i2] = new int[variables[i2].getDomain().getMaximumSize()];
            ++i2;
        }
    }

    private void init() {
        this.nbActiveFutureConstraints = this.inactive.length;
        this.nbViolatedPastConstraints = 0;
        Arrays.fill(this.inactive, 0);
        Constraint[] constraints = this.solver.getConstraints();
        int i = 0;
        while (i < constraints.length) {
            if (constraints[i].getVariableManager().areAllPastVariables()) {
                if (!constraints[i].seekSupport()) {
                    ++this.nbViolatedPastConstraints;
                }
                this.inactive[i] = -1;
                --this.nbActiveFutureConstraints;
            } else {
                Variable[] involvedVariables = constraints[i].getInvolvedVariables();
                int j = 0;
                while (j < involvedVariables.length) {
                    if (this.revisionManager.mustBeRevised(constraints[i], involvedVariables[j])) {
                        Elements elements = involvedVariables[j].getDomain().getElements();
                        int index = elements.getFirstPresent();
                        while (index != -1) {
                            this.cost[i][j][index] = !this.supportManager.seekNextSupport(i, j, index);
                            index = elements.getNextPresent(index);
                        }
                    } else {
                        Arrays.fill(this.cost[i][j], false);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private int computeMinNbViolatedConstraintsInvolving(Variable variable) {
        int min = Integer.MAX_VALUE;
        Elements elements = variable.getDomain().getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            int nb = this.computeNbViolatedConstraintsInvolving(variable, index);
            if (nb < min) {
                min = nb;
            }
            index = elements.getNextPresent(index);
        }
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (this.inactive[constraint.getId()] != 1 && this.inactive[constraint.getId()] != this.turn) {
                this.inactive[constraint.getId()] = this.turn;
                --this.nbActiveConstraints;
            }
            ++n;
        }
        return min;
    }

    private int computeLowerBoundFor(Variable variable, int index) {
        ++this.turn;
        this.nbActiveConstraints = this.nbActiveFutureConstraints;
        int cpt = 0;
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (this.inactive[constraint.getId()] != 1 && this.cost[constraint.getId()][constraint.getPositionOf(variable)][index]) {
                --this.nbActiveConstraints;
                this.inactive[constraint.getId()] = this.turn;
                ++cpt;
            }
            ++n;
        }
        VariableManager vm = this.solver.getVariableManager();
        Variable futureVariable = vm.getFirstFutureVariable();
        while (futureVariable != null) {
            if (futureVariable != variable && this.nbViolatedPastConstraints + (cpt += this.computeMinNbViolatedConstraintsInvolving(futureVariable)) + this.nbActiveConstraints < this.upperBound) break;
            futureVariable = vm.getNextFutureVariableAfter(futureVariable);
        }
        return cpt;
    }

    private int computeNbViolatedConstraintsInvolving(Variable variable, int index) {
        int cpt = 0;
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if ((this.inactive[constraint.getId()] == 0 || this.inactive[constraint.getId()] == variable.getId()) && this.cost[constraint.getId()][constraint.getPositionOf(variable)][index]) {
                ++cpt;
            }
            ++n;
        }
        return cpt;
    }

    private int setMni(Variable variable) {
        int[] t = this.mnis[variable.getId()];
        int bestIndex = -1;
        Elements elements = variable.getDomain().getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            t[index] = this.computeNbViolatedConstraintsInvolving(variable, index);
            if (bestIndex == -1 || t[index] < t[bestIndex]) {
                bestIndex = index;
            }
            index = elements.getNextPresent(index);
        }
        this.mni[variable.getId()] = bestIndex;
        Constraint[] constraintArray = variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (this.inactive[constraint.getId()] == 0) {
                this.inactive[constraint.getId()] = variable.getId();
                --this.nbActiveConstraints;
            }
            ++n;
        }
        return t[bestIndex];
    }

    private void setMnis() {
        this.sumMni = 0;
        VariableManager vm = this.solver.getVariableManager();
        Variable variable = vm.getFirstFutureVariable();
        while (variable != null) {
            this.sumMni += this.setMni(variable);
            variable = vm.getNextFutureVariableAfter(variable);
        }
    }

    private boolean propagate() {
        VariableManager vm = this.solver.getVariableManager();
        Variable variable = vm.getFirstFutureVariable();
        while (variable != null) {
            Domain domain = variable.getDomain();
            int domainSizeBefore = domain.getCurrentSize();
            Elements elements = domain.getElements();
            int index = elements.getFirstPresent();
            while (index != -1) {
                int nb = this.sumMni - this.mnis[variable.getId()][this.mni[variable.getId()]] + this.computeNbViolatedConstraintsInvolving(variable, index);
                if (this.nbViolatedPastConstraints + nb >= this.upperBound) {
                    domain.removeElementAt(index, null, 0);
                }
                index = elements.getNextPresent(index);
            }
            int nbRemovals = domainSizeBefore - domain.getCurrentSize();
            if (nbRemovals > 0 && domain.isEmpty()) {
                variable.incrementWeightedDegree();
                return false;
            }
            variable = vm.getNextFutureVariableAfter(variable);
        }
        return true;
    }

    private boolean go() {
        if (this.nbViolatedPastConstraints + this.nbActiveFutureConstraints < this.upperBound) {
            return true;
        }
        this.nbActiveConstraints = this.nbActiveFutureConstraints;
        this.setMnis();
        if (this.nbViolatedPastConstraints + this.sumMni >= this.upperBound) {
            return false;
        }
        return this.propagate();
    }

    public boolean checkConsistency() {
        this.upperBound = this.solver.getNbConstraints() + 1;
        this.init();
        return this.go();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        this.init();
        boolean consistent = this.go();
        if (consistent && this.solver.getVariableManager().areAllPastVariables()) {
            this.upperBound = this.nbViolatedPastConstraints;
            System.out.println("cost = " + this.upperBound);
        }
        return consistent;
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        this.init();
        return this.go();
    }
}

