/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.maxCSP;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.propagationSets.NewPropagationSet;
import abscon.solvers.Solver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public class MaxCSP
extends ForwardPropagationTechnique {
    private long upperBound;
    private boolean[][][] inconsistent;
    private long[][] nbDetectedInconsistencies;
    private int[] indexOfMinNbDetectedInconsistencies;
    private long[] offsetOfMinNbDetectedInconsistencies;
    private int[] IndexOfMaxNbDetectedInconsistencies;
    private long sumMni;
    private int lastInitDepth;
    protected NewPropagationSet propagationSet;
    private ConstraintPartition constraintPartition;
    private boolean[] traite;
    private int[] tmp = new int[2];
    protected boolean increment = true;

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        Constraint[] constraints = solver.getConstraints();
        this.inconsistent = new boolean[constraints.length][][];
        int i = 0;
        while (i < this.inconsistent.length) {
            Variable[] involvedVariables = constraints[i].getInvolvedVariables();
            this.inconsistent[i] = new boolean[involvedVariables.length][];
            int j = 0;
            while (j < this.inconsistent[i].length) {
                this.inconsistent[i][j] = new boolean[involvedVariables[j].getDomain().getMaximumSize()];
                ++j;
            }
            ++i;
        }
        Variable[] variables = solver.getVariables();
        this.indexOfMinNbDetectedInconsistencies = new int[variables.length];
        this.offsetOfMinNbDetectedInconsistencies = new long[variables.length];
        this.IndexOfMaxNbDetectedInconsistencies = new int[variables.length];
        this.nbDetectedInconsistencies = new long[variables.length][];
        int i2 = 0;
        while (i2 < this.nbDetectedInconsistencies.length) {
            this.nbDetectedInconsistencies[i2] = new long[variables[i2].getDomain().getMaximumSize()];
            ++i2;
        }
        this.constraintPartition = new ConstraintPartition(solver.getNbVariables(), solver.getNbConstraints());
        this.traite = new boolean[constraints.length];
        this.propagationSet = (NewPropagationSet)((ForwardPropagationTechnique)this).propagationSet;
    }

    public long getCostOf(Variable variable, int index) {
        return this.nbDetectedInconsistencies[variable.getId()][index] + this.computeOffset(variable, index);
    }

    private long setMni(Variable variable, boolean mustComputeNbViolatedConstraints) {
        long[] t = this.nbDetectedInconsistencies[variable.getId()];
        Elements elements = variable.getDomain().getElements();
        int bestMinIndex = elements.getFirstPresent();
        long offset = Long.MAX_VALUE;
        int bestMaxIndex = bestMinIndex;
        if (mustComputeNbViolatedConstraints) {
            t[bestMinIndex] = this.constraintPartition.computeNbViolatedConstraintsInvolving(variable, bestMinIndex);
        }
        int index = elements.getNextPresent(bestMinIndex);
        while (index != -1) {
            if (mustComputeNbViolatedConstraints) {
                t[index] = this.constraintPartition.computeNbViolatedConstraintsInvolving(variable, index);
            }
            if (t[index] < t[bestMinIndex]) {
                bestMinIndex = index;
                offset = t[bestMinIndex] - t[index];
            } else {
                if (t[index] > t[bestMaxIndex]) {
                    bestMaxIndex = index;
                }
                offset = Math.min(offset, t[index] - t[bestMinIndex]);
            }
            index = elements.getNextPresent(index);
        }
        this.indexOfMinNbDetectedInconsistencies[variable.getId()] = bestMinIndex;
        this.offsetOfMinNbDetectedInconsistencies[variable.getId()] = offset;
        this.IndexOfMaxNbDetectedInconsistencies[variable.getId()] = bestMaxIndex;
        return t[bestMinIndex];
    }

    private boolean setMni(boolean mustComputeNbViolatedConstraints) {
        this.sumMni = 0L;
        Variable greatestImpactVariable = null;
        long greatestImpact = -1L;
        VariableManager vm = this.solver.getVariableManager();
        Variable variable = vm.getFirstFutureVariable();
        while (variable != null) {
            this.sumMni += this.setMni(variable, mustComputeNbViolatedConstraints);
            long impact = this.nbDetectedInconsistencies[variable.getId()][this.indexOfMinNbDetectedInconsistencies[variable.getId()]];
            if (greatestImpactVariable == null || impact > greatestImpact) {
                greatestImpactVariable = variable;
                greatestImpact = impact;
            }
            if (this.constraintPartition.weightedSumOfViolatedPastConstraints + this.sumMni >= this.upperBound) {
                greatestImpactVariable.incrementWeightedDegree();
                return false;
            }
            variable = vm.getNextFutureVariableAfter(variable);
        }
        return true;
    }

    private void updateNbInconsistencies() {
        Variable[] variables = this.solver.getVariables();
        while (this.propagationSet.size() > 0) {
            Variable revisedVariable = this.propagationSet.getFirstVariable();
            this.propagationSet.remove(0);
            Constraint[] constraintArray = revisedVariable.getInvolvingConstraints();
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                Variable variable = variables[this.constraintPartition.membership[constraint.getId()]];
                if (variable != revisedVariable) {
                    int i = constraint.getId();
                    int j = constraint.getPositionOf(variable);
                    long[] t = this.nbDetectedInconsistencies[variable.getId()];
                    if (this.revisionManager.mustBeRevised(constraint, variable)) {
                        Elements elements = variable.getDomain().getElements();
                        int index = elements.getFirstPresent();
                        while (index != -1) {
                            if (!this.inconsistent[i][j][index] && !this.supportManager.seekNextSupport(i, j, index)) {
                                this.inconsistent[i][j][index] = true;
                                int n3 = index;
                                t[n3] = t[n3] + (long)constraint.getWeight();
                            }
                            index = elements.getNextPresent(index);
                        }
                    }
                }
                ++n;
            }
        }
    }

    private long computeOffset(Variable variable, int index) {
        long cpt = 0L;
        VariableManager vm = this.solver.getVariableManager();
        Variable futureVariable = vm.getFirstFutureVariable();
        while (futureVariable != null) {
            Constraint constraint;
            if (variable != futureVariable && this.offsetOfMinNbDetectedInconsistencies[futureVariable.getId()] != 0L && (constraint = variable.getBinaryConstraintWith(futureVariable)) != null && this.constraintPartition.membership[constraint.getId()] == futureVariable.getId()) {
                int futureIndex = this.indexOfMinNbDetectedInconsistencies[futureVariable.getId()];
                int futurePosition = constraint.getPositionOf(futureVariable);
                if (!this.inconsistent[constraint.getId()][futurePosition][futureIndex]) {
                    this.tmp[futurePosition] = futureIndex;
                    this.tmp[futurePosition == 1 ? 0 : 1] = index;
                    if (!constraint.seekSupport(this.tmp)) {
                        cpt += (long)constraint.getWeight();
                    }
                }
            }
            futureVariable = vm.getNextFutureVariableAfter(futureVariable);
        }
        return cpt;
    }

    protected boolean propagate() {
        this.propagationSet.clear();
        do {
            VariableManager vm = this.solver.getVariableManager();
            Variable variable = vm.getFirstFutureVariable();
            while (variable != null) {
                long[] t = this.nbDetectedInconsistencies[variable.getId()];
                long base = this.constraintPartition.weightedSumOfViolatedPastConstraints + this.sumMni - t[this.indexOfMinNbDetectedInconsistencies[variable.getId()]];
                if (base + t[this.IndexOfMaxNbDetectedInconsistencies[variable.getId()]] >= this.upperBound) {
                    Domain domain = variable.getDomain();
                    int domainSizeBefore = domain.getCurrentSize();
                    Elements elements = domain.getElements();
                    int index = elements.getFirstPresent();
                    while (index != -1) {
                        assert (t[index] == this.constraintPartition.computeNbViolatedConstraintsInvolving(variable, index));
                        long offset = this.computeOffset(variable, index);
                        if (base + t[index] + offset >= this.upperBound) {
                            domain.removeElementAt(index, null, 0);
                        }
                        index = elements.getNextPresent(index);
                    }
                    if (domainSizeBefore - domain.getCurrentSize() > 0) {
                        if (domain.isEmpty()) {
                            if (this.increment) {
                                variable.incrementWeightedDegree();
                            }
                            this.propagationSet.clear();
                            return false;
                        }
                        this.propagationSet.add(variable);
                    }
                }
                variable = vm.getNextFutureVariableAfter(variable);
            }
            if (this.propagationSet.size() == 0) {
                return true;
            }
            this.updateNbInconsistencies();
        } while (this.setMni(false));
        return false;
    }

    private boolean go() {
        this.constraintPartition.init();
        if (this.constraintPartition.weightedSumOfViolatedPastConstraints + this.constraintPartition.weightedSumOfFutureConstraints < this.upperBound) {
            return true;
        }
        return this.setMni(true) && this.propagate();
    }

    public boolean checkConsistency() {
        this.upperBound = ConfigurationManager.getInt(this.getLevel(), String.valueOf(this.getPhase()) + "/" + "propagationTechnique", "upperBound");
        if (this.upperBound == -1L) {
            long sum = 0L;
            Constraint[] constraintArray = this.solver.getConstraints();
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                sum += (long)constraint.getWeight();
                ++n;
            }
            this.upperBound = sum;
        }
        return this.go();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        if (!this.propagationSet.isNogoodConsistent(variable)) {
            return false;
        }
        boolean consistent = this.go();
        if (consistent && this.solver.getVariableManager().areAllPastVariables()) {
            this.upperBound = this.constraintPartition.weightedSumOfViolatedPastConstraints;
            if (this.solver.getLastSolution() == null) {
                System.out.println();
                System.out.println("s SATISFIABLE");
            }
            System.out.println("o " + ((long)this.solver.getNbConstraints() - this.upperBound));
            System.out.println("c " + this.upperBound);
            this.solver.recordlastSolution();
            System.out.flush();
        }
        return consistent;
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        return this.go();
    }

    class ConstraintPartition {
        int[] membership;
        int[] next;
        int[] head;
        int[] size;
        int pastHead;
        int nbPastConstraints;
        long weightedSumOfViolatedPastConstraints;
        long weightedSumOfFutureConstraints;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ConstraintPartition.class.desiredAssertionStatus();
        }

        ConstraintPartition(int nbVariables, int nbConstraints) {
            this.membership = new int[nbConstraints];
            this.next = new int[nbConstraints];
            this.head = new int[nbVariables];
            this.size = new int[nbVariables];
        }

        void init() {
            MaxCSP.this.lastInitDepth = MaxCSP.this.solver.getCurrentDepth();
            Arrays.fill(this.head, -1);
            Arrays.fill(this.size, 0);
            this.pastHead = -1;
            this.nbPastConstraints = 0;
            this.weightedSumOfViolatedPastConstraints = 0L;
            this.weightedSumOfFutureConstraints = 0L;
            int i = 0;
            while (i < MaxCSP.this.nbDetectedInconsistencies.length) {
                Arrays.fill(MaxCSP.this.nbDetectedInconsistencies[i], 0L);
                ++i;
            }
            Constraint[] constraintArray = MaxCSP.this.solver.getConstraints();
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                if (constraint.getVariableManager().areAllPastVariables()) {
                    this.membership[constraint.getId()] = -1;
                    this.next[constraint.getId()] = this.pastHead;
                    this.pastHead = constraint.getId();
                    ++this.nbPastConstraints;
                    if (!constraint.seekSupport()) {
                        this.weightedSumOfViolatedPastConstraints += (long)constraint.getWeight();
                    }
                } else {
                    this.weightedSumOfFutureConstraints += (long)constraint.getWeight();
                    int i2 = constraint.getId();
                    Variable[] involvedVariables = constraint.getInvolvedVariables();
                    int bestVariablePosition = -1;
                    double bestEvaluation = -1.0;
                    int j = 0;
                    while (j < involvedVariables.length) {
                        if (!involvedVariables[j].isAssigned()) {
                            double cpt = 0.0;
                            if (MaxCSP.this.revisionManager.mustBeRevised(constraint, involvedVariables[j])) {
                                Elements elements = involvedVariables[j].getDomain().getElements();
                                int index = elements.getFirstPresent();
                                while (index != -1) {
                                    boolean consistent = MaxCSP.this.supportManager.seekNextSupport(i2, j, index);
                                    boolean bl = ((MaxCSP)MaxCSP.this).inconsistent[i2][j][index] = !consistent;
                                    if (!consistent) {
                                        cpt += 1.0;
                                    }
                                    index = elements.getNextPresent(index);
                                }
                            } else {
                                Arrays.fill(MaxCSP.this.inconsistent[i2][j], false);
                            }
                            double evaluation = cpt / (double)involvedVariables[j].getCurrentDomainSize();
                            if (bestEvaluation == -1.0 || evaluation > bestEvaluation) {
                                bestVariablePosition = j;
                                bestEvaluation = evaluation;
                            }
                        }
                        ++j;
                    }
                    Variable bestVariable = involvedVariables[bestVariablePosition];
                    this.membership[constraint.getId()] = bestVariable.getId();
                    this.next[constraint.getId()] = this.head[bestVariable.getId()];
                    this.head[bestVariable.getId()] = constraint.getId();
                    int n3 = bestVariable.getId();
                    this.size[n3] = this.size[n3] + 1;
                }
                ++n;
            }
            if (!$assertionsDisabled && !this.control()) {
                throw new AssertionError();
            }
        }

        long computeNbViolatedConstraintsInvolving(Variable variable, int index) {
            Constraint[] constraints = MaxCSP.this.solver.getConstraints();
            long cpt = 0L;
            int current = this.head[variable.getId()];
            while (current != -1) {
                if (MaxCSP.this.inconsistent[current][constraints[current].getPositionOf(variable)][index]) {
                    cpt += (long)constraints[current].getWeight();
                }
                current = this.next[current];
            }
            return cpt;
        }

        private boolean control() {
            int i = 0;
            while (i < this.head.length) {
                int current = this.head[i];
                while (current != -1) {
                    if (this.membership[current] != i) {
                        return false;
                    }
                    current = this.next[current];
                }
                ++i;
            }
            Constraint[] constraints = MaxCSP.this.solver.getConstraints();
            int i2 = 0;
            while (i2 < this.membership.length) {
                if (this.membership[i2] == -1) {
                    if (!constraints[i2].getVariableManager().areAllPastVariables()) {
                        return false;
                    }
                } else {
                    int variableId = this.membership[i2];
                    boolean found = false;
                    int current = this.head[variableId];
                    while (!found && current != -1) {
                        if (current == i2) {
                            found = true;
                        }
                        current = this.next[current];
                    }
                    if (!found) {
                        return false;
                    }
                }
                ++i2;
            }
            return true;
        }

        private void display() {
            Variable[] variables = MaxCSP.this.solver.getVariables();
            Constraint[] constraints = MaxCSP.this.solver.getConstraints();
            int i = 0;
            while (i < this.head.length) {
                System.out.print(variables[i] + " of size " + this.size[i] + " :");
                int current = this.head[i];
                while (current != -1) {
                    System.out.print(constraints[current] + " ");
                    current = this.next[current];
                }
                System.out.println();
                ++i;
            }
        }
    }
}

