/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques.cpc;

import abscon.constraints.Constraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import java.util.Arrays;

public class PropagationSetOfValues {
    private int[][][] positions;
    private int nbCurrentValues;
    private Constraint[] constraints;
    private Variable[] variables;
    private int[] indexes;
    private int head;
    private int capacity = 0;

    public Constraint getConstraint(int i) {
        return this.constraints[i];
    }

    public Variable getVariable(int i) {
        return this.variables[i];
    }

    public int getIndex(int i) {
        return this.indexes[i];
    }

    public Constraint getFirstConstraint() {
        return this.constraints[this.head];
    }

    public Variable getFirstVariable() {
        return this.variables[this.head];
    }

    public int getFirstIndex() {
        return this.indexes[this.head];
    }

    public Constraint getLastConstraint() {
        return this.constraints[(this.head + this.nbCurrentValues - 1) % this.capacity];
    }

    public Variable getLastVariable() {
        return this.variables[(this.head + this.nbCurrentValues - 1) % this.capacity];
    }

    public int getLastIndex() {
        return this.indexes[(this.head + this.nbCurrentValues - 1) % this.capacity];
    }

    public PropagationSetOfValues(Problem problem) {
        this.positions = new int[problem.getNbConstraints()][][];
        int i = 0;
        while (i < this.positions.length) {
            Constraint constraint = problem.getConstraint(i);
            if (constraint.getArity() == 2) {
                this.positions[i] = new int[2][];
                int j = 0;
                while (j < this.positions[i].length) {
                    this.positions[i][j] = new int[constraint.getInvolvedVariable(j).getDomain().getMaximumSize()];
                    Arrays.fill(this.positions[i][j], -1);
                    this.capacity += constraint.getInvolvedVariable(j).getDomain().getMaximumSize();
                    ++j;
                }
            }
            ++i;
        }
        this.constraints = new Constraint[this.capacity];
        this.variables = new Variable[this.capacity];
        this.indexes = new int[this.capacity];
    }

    public void add(Constraint constraint, Variable variable, int index) {
        int firstFreePosition;
        int variablePosition = constraint.getPositionOf(variable);
        if (this.positions[constraint.getId()][variablePosition][index] != -1) {
            return;
        }
        this.positions[constraint.getId()][variablePosition][index] = firstFreePosition = (this.head + this.nbCurrentValues) % this.capacity;
        this.constraints[firstFreePosition] = constraint;
        this.variables[firstFreePosition] = variable;
        this.indexes[firstFreePosition] = index;
        ++this.nbCurrentValues;
    }

    public void remove(int i) {
        assert (i >= 0 && i < this.nbCurrentValues);
        int position = (this.head + i) % this.capacity;
        this.positions[this.constraints[position].getId()][this.constraints[position].getPositionOf((Variable)this.variables[position])][this.indexes[position]] = -1;
        if (position == this.head) {
            this.head = (this.head + 1) % this.capacity;
        } else {
            int lastPosition = (this.head + this.nbCurrentValues - 1) % this.capacity;
            if (position != lastPosition) {
                this.constraints[position] = this.constraints[lastPosition];
                this.variables[position] = this.variables[lastPosition];
                this.indexes[position] = this.indexes[lastPosition];
                this.positions[this.constraints[position].getId()][this.constraints[position].getPositionOf((Variable)this.variables[position])][this.indexes[position]] = position;
            }
        }
        --this.nbCurrentValues;
    }

    public int size() {
        return this.nbCurrentValues;
    }
}

