/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques;

import abscon.constraints.Constraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSetOfConstraints;
import abscon.propagationTechniques.propagationSets.PropagationSetOfVariables;
import abscon.solvers.Solver;

public class SpecificPropagationTechnique
extends ForwardPropagationTechnique {
    private int[] exCurrentSizes;

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        if (!(this.propagationSet instanceof PropagationSetOfVariables) && !(this.propagationSet instanceof PropagationSetOfConstraints)) {
            throw new IncompatiblePropertiesException();
        }
        this.exCurrentSizes = new int[solver.getNbVariables()];
    }

    public boolean isConsistent(Constraint constraint) {
        Variable[] variables = constraint.getInvolvedVariables();
        int i = 0;
        while (i < variables.length) {
            this.exCurrentSizes[i] = variables[i].getDomain().getCurrentSize();
            ++i;
        }
        Variable variable = constraint.isSpecificIncoherent();
        if (variable == null) {
            int i2 = 0;
            while (i2 < variables.length) {
                int nbRemovals = this.exCurrentSizes[i2] - variables[i2].getDomain().getCurrentSize();
                if (nbRemovals > 0) {
                    this.propagationSet.updateAfterEffectiveRevisionOf(constraint, variables[i2], nbRemovals);
                }
                ++i2;
            }
        } else {
            this.incrementNbFailuresOf(constraint, variable);
        }
        return variable == null;
    }

    public boolean checkConsistency() {
        this.propagationSet.fill();
        return this.checkConsistencyOfPropagationSet();
    }
}

