/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques;

import abscon.constraints.Constraint;
import abscon.constraints.global.GlobalConstraint;
import abscon.constraints.optimization.OptimizationConstraint;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Variable;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.propagationTechniques.forwardPropagationTechniques.fc.ForwardChecking0;
import abscon.propagationTechniques.revisionManagers.RevisionManager;
import abscon.propagationTechniques.substitutabilityManagers.SubstitutabilityManager;
import abscon.propagationTechniques.supportManagers.SupportManager;
import abscon.propagationTechniques.supportManagers.SupportManager2003;
import abscon.solvers.Solver;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.reflection.Factory;

public abstract class ForwardPropagationTechnique
extends PropagationTechnique {
    protected SupportManager supportManager;
    protected RevisionManager revisionManager;
    protected boolean limited;
    protected SubstitutabilityManager substitutabilityManager;
    private Constraint lastConstraintOfFailure;
    protected boolean controlConsistencyWithTightness = false;

    public SupportManager getSupportManager() {
        return this.supportManager;
    }

    public RevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    public void attachTo(Solver solver) {
        super.attachTo(solver);
        String prefix = "/propagationTechnique";
        String className = ConfigurationManager.getString(solver.getLevelInResolution(), String.valueOf(this.getPhase()) + prefix + "/" + "supportManager", "class");
        this.supportManager = (SupportManager)Factory.getInstanceOf(className, SupportManager.class);
        this.supportManager.attachTo(this);
        if (solver.getProblem().getNbGlobalConstraints() > 0) {
            this.limited = true;
        }
        int futureLimitation = ConfigurationManager.getInt(this.getLevel(), String.valueOf(this.getPhase()) + prefix, "futureLimitation");
        int spaceLimitation = ConfigurationManager.getInt(this.getLevel(), String.valueOf(this.getPhase()) + prefix, "spaceLimitation");
        if (futureLimitation != -1 || spaceLimitation != -1) {
            Constraint[] constraintArray = solver.getConstraints();
            int n = 0;
            int n2 = constraintArray.length;
            while (n < n2) {
                Constraint constraint = constraintArray[n];
                if (!(constraint instanceof GlobalConstraint) && constraint.setLimitation(futureLimitation, spaceLimitation)) {
                    this.limited = true;
                }
                ++n;
            }
        }
        this.boundConsistency = ConfigurationManager.getBoolean(this.getLevel(), String.valueOf(this.getPhase()) + prefix, "boundConsistency");
        if (this.boundConsistency && this.supportManager instanceof SupportManager2003) {
            throw new IncompatiblePropertiesException();
        }
        className = ConfigurationManager.getString(solver.getLevelInResolution(), String.valueOf(this.getPhase()) + prefix + "/" + "revisionManager", "class");
        this.revisionManager = (RevisionManager)Factory.getInstanceOf(className, RevisionManager.class);
        this.revisionManager.attachTo(this);
        this.multiPass = true;
    }

    public boolean admits(Constraint constraint) {
        return constraint.canBeCurrentlyPropagated();
    }

    public void initializeBeforePreprocessing() {
        super.initializeBeforePreprocessing();
        this.supportManager.initializeStructures();
    }

    public void initializeBeforeRun() {
        super.initializeBeforeRun();
        if (this.solver.getPreproPropagationTechnique() == this && this.solver.getRestarter().getCurrentRun() == 0 && this.solver.getResolution().getAuxiliarySolver() != this.solver) {
            this.revisionManager.initializeStructures();
        } else {
            this.supportManager.initializeStructures();
            this.revisionManager.initializeStructures();
        }
    }

    public final boolean checkConsistencyOfPropagationSet() {
        if (this.substitutabilityManager == null) {
            return super.checkConsistencyOfPropagationSet();
        }
        boolean consistent = super.checkConsistencyOfPropagationSet();
        if (!consistent) {
            return false;
        }
        this.substitutabilityManager.removeSubstitutableValues();
        return true;
    }

    private boolean checkConsistencyFrom(Variable variable, int depthLimitToUpdateStructures) {
        this.supportManager.initAfterModificationOf(variable, this.getProgression(), depthLimitToUpdateStructures);
        assert (this.supportManager.controlSupports());
        if (variable.isAssigned() || !(this instanceof ForwardChecking0)) {
            this.propagationSet.initAfterModificationOf(variable);
        }
        return this.checkConsistencyOfPropagationSet();
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        assert (variable.isAssigned());
        if (this.guaranteeConsistencyOfValueSingletons() && !variable.getDomain().isThereAtLeastARemovalAtCurrentDepth() && this.getProgression()) {
            this.propagationSet.clear();
            return true;
        }
        this.lastConstraintOfFailure = null;
        return this.checkConsistencyFrom(variable, this.solver.getCurrentDepth() + (this.getProgression() ? 0 : -1));
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        assert (!variable.isAssigned() && variable.getCurrentDomainSize() > 0) : "var " + variable + " assigned: " + variable.isAssigned() + " domain size = " + variable.getCurrentDomainSize();
        assert (!this.getProgression());
        Constraint[] constraintArray = this.solver.getProblem().getConstraintsTriggeredUponBacktracking();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            constraint.triggerUponBacktracking();
            ++n;
        }
        return this.checkConsistencyFrom(variable, variableDepth - 1);
    }

    public Constraint getLastConstraintOfFailure() {
        return this.lastConstraintOfFailure;
    }

    public void incrementNbFailuresOf(Constraint constraint, Variable variable) {
        if (this.solver.getCurrentDepth() == 0) {
            return;
        }
        this.lastConstraintOfFailure = constraint;
        constraint.incrementWeigthedDegree();
        Variable[] variableArray = constraint.getInvolvedVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable involvedVariable = variableArray[n];
            involvedVariable.incrementWeightedDegree();
            ++n;
        }
    }

    public boolean isConsistent(int constraintId, int variablePosition, int index) {
        return this.supportManager.seekNextSupport(constraintId, variablePosition, index);
    }

    private boolean mustAvoidRevisionOf(Constraint constraint, Variable variable) {
        if (!this.controlConsistencyWithTightness) {
            return false;
        }
        int domainSizeBefore = variable.getCurrentDomainSize();
        int brotherSizeBefore = constraint.getFirstVariableDifferentFrom(variable).getCurrentDomainSize();
        double d = constraint.tightness;
        int i = 1;
        while (i < brotherSizeBefore) {
            d *= constraint.tightness;
            ++i;
        }
        return domainSizeBefore > 1 && brotherSizeBefore > 1 && (double)(2 * this.solver.getNbConstraints()) * d * (double)domainSizeBefore < 1.0;
    }

    public boolean isConsistent(Constraint constraint, Variable variable) {
        assert (!variable.isAssigned() && constraint.isBinding(variable));
        if (!this.revisionManager.mustBeRevised(constraint, variable)) {
            return true;
        }
        if (this.mustAvoidRevisionOf(constraint, variable)) {
            return true;
        }
        ++this.nbRevisions;
        int domainSizeBefore = variable.getCurrentDomainSize();
        this.revisionManager.revise(constraint, variable);
        int domainSizeAfter = variable.getCurrentDomainSize();
        int nbRemovals = domainSizeBefore - domainSizeAfter;
        if (nbRemovals == 0) {
            ++this.nbUselessRevisions;
        } else {
            constraint.incrementNbEffectiveRevisionsOf(nbRemovals);
            if (domainSizeAfter == 0) {
                this.incrementNbFailuresOf(constraint, variable);
                this.culprit = variable;
                return false;
            }
            this.propagationSet.updateAfterEffectiveRevisionOf(constraint, variable, nbRemovals);
        }
        return true;
    }

    public boolean isConsistent(Constraint constraint) {
        if (constraint instanceof GlobalConstraint) {
            return constraint.isConsistent();
        }
        Variable uniqueVariableWithReducedDomain = constraint.getDomainManager().getUniqueVariableWithReducedDomain();
        assert (constraint.getDomainManager().getNbRecentReducedDomains() > 0);
        constraint.getDomainManager().setNbRecentDomainRemovals(0);
        Variable futureVariable = constraint.getFirstFutureVariable();
        while (futureVariable != null) {
            if ((futureVariable != uniqueVariableWithReducedDomain || this.boundConsistency || constraint instanceof OptimizationConstraint) && !this.isConsistent(constraint, futureVariable)) {
                return false;
            }
            futureVariable = constraint.getNextFutureVariableAfter(futureVariable);
        }
        return true;
    }

    public boolean isConsistent(Variable variable, Constraint constraint) {
        if (constraint instanceof GlobalConstraint) {
            return constraint.isConsistent(variable);
        }
        if (constraint.getCounter() > variable.getCounter()) {
            return true;
        }
        if (!constraint.canBeCurrentlyPropagated()) {
            return true;
        }
        if (variable.isAssigned() || this.boundConsistency) {
            Variable futureVariable = constraint.getFirstFutureVariable();
            while (futureVariable != null) {
                if (!this.isConsistent(constraint, futureVariable)) {
                    constraint.incrementCounter();
                    return false;
                }
                futureVariable = constraint.getNextFutureVariableAfter(futureVariable);
            }
        } else {
            boolean alsoVariable = constraint.getArity() == 1 && !variable.isAssigned();
            Variable futureVariable = constraint.getFirstFutureVariable();
            while (futureVariable != null) {
                if (futureVariable != variable) {
                    if (constraint.getCounter() < futureVariable.getCounter()) {
                        alsoVariable = true;
                    }
                    if (!this.isConsistent(constraint, futureVariable)) {
                        constraint.incrementCounter();
                        return false;
                    }
                }
                futureVariable = constraint.getNextFutureVariableAfter(futureVariable);
            }
            if (alsoVariable && !this.isConsistent(constraint, variable)) {
                constraint.incrementCounter();
                return false;
            }
        }
        constraint.incrementCounter();
        return true;
    }
}

