/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques.forwardPropagationTechniques;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.problem.cliques.PathManager;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.tools.elements.Elements;

public class ArcConsistency
extends ForwardPropagationTechnique {
    public boolean guaranteeConsistencyOfValueSingletons() {
        if (this.limited || this.controlConsistencyWithTightness) {
            return false;
        }
        return !(this.solver instanceof SystematicSolver) || ((SystematicSolver)this.solver).getNogoodManager() != null;
    }

    public boolean checkConsistency() {
        this.propagationSet.fill();
        if (!this.checkConsistencyOfPropagationSet()) {
            return false;
        }
        assert (this.controlConsistency(false));
        return true;
    }

    protected boolean controlConsistencyOfIndex(Variable variable, int index, boolean path) {
        Constraint[] constraints = variable.getInvolvingConstraints();
        int i = 0;
        while (i < constraints.length) {
            int[] tuple = constraints[i].getTupleManager().getLocalTuple();
            boolean ca = constraints[i].isCandidateAttentive();
            constraints[i].setCandidateAttentive(false);
            int variablePosition = constraints[i].getPositionOf(variable);
            boolean consistent = constraints[i].seekSupport(variablePosition, index, tuple);
            if (path) {
                PathManager cliqueManager = constraints[i].getProblem().getCliqueManager();
                while (consistent) {
                    if (cliqueManager.isPathConsistent(constraints[i], tuple)) break;
                    consistent = constraints[i].seekAnotherSupport(variablePosition, index, tuple);
                }
            }
            constraints[i].setCandidateAttentive(ca);
            if (!consistent) {
                System.out.println(" " + variable + " <- " + index + " not supported by " + constraints[i]);
                Variable[] involvedVariables = constraints[i].getInvolvedVariables();
                int j = 0;
                while (j < involvedVariables.length) {
                    involvedVariables[j].displayExhaustively();
                    ++j;
                }
                constraints[i].displayExhaustively();
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean controlConsistency(boolean path) {
        if (!this.guaranteeConsistencyOfValueSingletons()) {
            return true;
        }
        Variable[] variables = this.solver.getVariables();
        int i = 0;
        while (i < variables.length) {
            Variable currentVariable = variables[i];
            Elements elements = currentVariable.getDomain().getElements();
            if (this.boundConsistency) {
                if (!this.controlConsistencyOfIndex(currentVariable, elements.getFirstPresent(), path)) {
                    return false;
                }
                if (!this.controlConsistencyOfIndex(currentVariable, elements.getLastPresent(), path)) {
                    return false;
                }
            } else {
                int index = elements.getFirstPresent();
                while (index != -1) {
                    if (!this.controlConsistencyOfIndex(currentVariable, index, path)) {
                        return false;
                    }
                    index = elements.getNextPresent(index);
                }
            }
            ++i;
        }
        return true;
    }

    public boolean checkConsistencyAfterAssignmentOf(Variable variable) {
        if (!super.checkConsistencyAfterAssignmentOf(variable)) {
            return false;
        }
        assert (this.controlConsistency(false));
        return true;
    }

    public boolean checkConsistencyAfterRefutationOf(Variable variable, int variableDepth) {
        if (!super.checkConsistencyAfterRefutationOf(variable, variableDepth)) {
            return false;
        }
        assert (this.controlConsistency(false)) : "problem from unassignment of " + variable;
        return true;
    }
}

