/*
 * Decompiled with CFR 0.152.
 */
package abscon.propagationTechniques;

import abscon.constraints.Constraint;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.Variable;
import abscon.propagationTechniques.propagationSets.PropagationSet;
import abscon.solvers.Solver;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.reflection.Factory;

public abstract class PropagationTechnique {
    protected Solver solver;
    protected PropagationSet propagationSet;
    protected boolean multiPass;
    protected boolean boundConsistency;
    protected boolean pathExtension;
    protected int lastFilteringDepth;
    protected long nbPropagations;
    protected long nbRevisions;
    protected long nbUselessRevisions;
    protected Object culprit;

    public boolean getPathExtension() {
        return this.pathExtension;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public PropagationSet getPropagationSet() {
        return this.propagationSet;
    }

    public boolean isMultiPass() {
        return this.multiPass;
    }

    public boolean isBoundConsistency() {
        return this.boundConsistency;
    }

    public String getPhase() {
        return this.solver.getPreproPropagationTechnique() == this ? "preprocessing" : "search";
    }

    public int getLevel() {
        return this.solver.getLevelInResolution();
    }

    public long getNbPropagations() {
        return this.nbPropagations;
    }

    public long getNbRevisions() {
        return this.nbRevisions;
    }

    public long getNbUselessRevisions() {
        return this.nbUselessRevisions;
    }

    public Object getCulprit() {
        return this.culprit;
    }

    public void setCulprit(Object culprit) {
        this.culprit = culprit;
    }

    public void resetCounters() {
        this.nbPropagations = 0L;
        this.nbRevisions = 0L;
        this.nbUselessRevisions = 0L;
    }

    public void attachTo(Solver solver) {
        this.solver = solver;
        String className = ConfigurationManager.getString(this.getLevel(), String.valueOf(this.getPhase()) + "/" + "propagationTechnique" + "/" + "propagationSet", "class");
        this.propagationSet = (PropagationSet)Factory.getInstanceOf(className, PropagationSet.class);
        this.propagationSet.attachTo(this);
    }

    public boolean getProgression() {
        return this.solver.getCurrentDepth() > this.lastFilteringDepth;
    }

    public boolean guaranteeConsistencyOfValueSingletons() {
        return false;
    }

    public void initializeBeforePreprocessing() {
        assert (this.propagationSet.controlClear());
    }

    public void initializeBeforeRun() {
        assert (this.propagationSet.controlClear());
    }

    public abstract boolean admits(Constraint var1);

    public boolean checkConsistencyOfPropagationSet() {
        this.lastFilteringDepth = this.solver.getCurrentDepth();
        while (this.propagationSet.size() != 0) {
            ++this.nbPropagations;
            if (this.propagationSet.pickElementAndCheckConsistency()) continue;
            this.propagationSet.clear();
            return false;
        }
        assert (this.propagationSet.controlClear());
        return true;
    }

    public abstract boolean checkConsistency();

    public abstract boolean checkConsistencyAfterAssignmentOf(Variable var1);

    public abstract boolean checkConsistencyAfterRefutationOf(Variable var1, int var2);

    public abstract boolean isConsistent(int var1, int var2, int var3);

    public abstract boolean isConsistent(Constraint var1, Variable var2);

    public abstract boolean isConsistent(Constraint var1);

    public boolean isConsistent(Variable variable, Constraint constraint) {
        throw new MissingImplementationException();
    }
}

