/*
 * Decompiled with CFR 0.152.
 */
package abscon.problem;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.solvers.systematicSolvers.SystematicSolver;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;

public class Explanations {
    public static final int DEFINITIVELY_REMOVED = -1;
    private Domain domain;
    private Variable[] variables;
    private boolean[][] culpritStatus;
    private Variable[][] culprits;
    private int[] nbCulprits;
    private int explanationMode = 3;

    public Variable getCulprit(int index, int i) {
        assert (i < this.nbCulprits[index]);
        return this.culprits[index][i];
    }

    public int getNbCulpritsOf(int index) {
        return this.nbCulprits[index];
    }

    public Explanations(Domain domain) {
        this.domain = domain;
        this.variables = domain.getVariable().getProblem().getVariables();
        this.culpritStatus = new boolean[domain.getMaximumSize()][this.variables.length];
        this.culprits = new Variable[domain.getMaximumSize()][this.variables.length];
        this.nbCulprits = new int[domain.getMaximumSize()];
    }

    public void setDefinitiveExplanationOf(int index) {
        assert (this.controlNoExplanation(index));
        this.nbCulprits[index] = -1;
    }

    public boolean hasDefinitiveExplanation(int index) {
        return this.nbCulprits[index] == -1;
    }

    public void setAutoExplanationOf(int index) {
        assert (this.controlNoExplanation(index));
        this.culpritStatus[index][this.domain.getId()] = true;
        this.culprits[index][0] = this.domain.getVariable();
        this.nbCulprits[index] = 1;
    }

    private void addPotentiallyNewCulprit(int index, Variable variable) {
        if (!this.culpritStatus[index][variable.getId()]) {
            this.culpritStatus[index][variable.getId()] = true;
            int n = index;
            int n2 = this.nbCulprits[n];
            this.nbCulprits[n] = n2 + 1;
            this.culprits[index][n2] = variable;
        }
    }

    public void setExplanationOf(int invalidIndex, Variable[] culpritVariables, int nbCulpritVariables) {
        assert (this.controlNoExplanation(invalidIndex) && (culpritVariables == null || nbCulpritVariables > 0));
        if (culpritVariables == null) {
            VariableManager manager = ((SystematicSolver)this.domain.getVariable().getProblem().getSolver()).getVariableManager();
            Variable pastVariable = manager.getLastPastVariable();
            while (pastVariable != null) {
                this.culpritStatus[invalidIndex][pastVariable.getId()] = true;
                int n = invalidIndex;
                int n2 = this.nbCulprits[n];
                this.nbCulprits[n] = n2 + 1;
                this.culprits[invalidIndex][n2] = pastVariable;
                pastVariable = manager.getPrevPastVariableBefore(pastVariable);
            }
        } else {
            int i = 0;
            while (i < nbCulpritVariables) {
                if (culpritVariables[i] != this.domain.getVariable()) {
                    if (culpritVariables[i].isAssigned()) {
                        this.addPotentiallyNewCulprit(invalidIndex, culpritVariables[i]);
                    } else {
                        Explanations otherExplanations = culpritVariables[i].getDomain().getExplanations();
                        Elements elements = culpritVariables[i].getDomain().getElements();
                        int index = elements.getLastAbsent();
                        while (index != -1) {
                            int j = 0;
                            while (j < otherExplanations.nbCulprits[index]) {
                                this.addPotentiallyNewCulprit(invalidIndex, otherExplanations.culprits[index][j]);
                                ++j;
                            }
                            index = elements.getPrevAbsent(index);
                        }
                    }
                }
                ++i;
            }
        }
        if (this.nbCulprits[invalidIndex] == 0) {
            this.setDefinitiveExplanationOf(invalidIndex);
        }
    }

    public void setExplanationOf(int invalidIndex, Constraint culpritConstraint) {
        Variable[] culpritVariables = culpritConstraint.getInvolvedVariables();
        this.setExplanationOf(invalidIndex, culpritVariables, culpritVariables.length);
    }

    public void removeExplanationOf(int index, Variable exPastVariable) {
        if (!this.culpritStatus[index][exPastVariable.getId()]) {
            return;
        }
        assert (this.nbCulprits[index] != -1 && this.controlOneExplanation(index, exPastVariable));
        int i = 0;
        while (i < this.nbCulprits[index]) {
            this.culpritStatus[index][this.culprits[index][i].getId()] = false;
            ++i;
        }
        this.nbCulprits[index] = 0;
        if (this.domain.getVariable().isAssigned()) {
            this.setAutoExplanationOf(index);
        } else {
            this.domain.addElementAt(index);
        }
    }

    public void removeExplanationsSetFrom(Variable exPastVariable) {
        int index = 0;
        while (index < this.culpritStatus.length) {
            this.removeExplanationOf(index, exPastVariable);
            ++index;
        }
    }

    public void removeDefinitiveExplanationOf(int index) {
        assert (this.nbCulprits[index] == -1);
        this.nbCulprits[index] = 0;
        this.domain.addElementAt(index);
    }

    public void displayExplanations() {
        System.out.println("Explanations of " + this.domain);
        int i = 0;
        while (i < this.culprits.length) {
            if (this.nbCulprits[i] != 0) {
                String s = "";
                if (this.nbCulprits[i] == -1) {
                    s = "definitively removed ";
                } else {
                    int j = 0;
                    while (j < this.nbCulprits[i]) {
                        s = String.valueOf(s) + this.culprits[i][j] + "<-" + this.culprits[i][j].getDomain().getUniqueValue() + " ";
                        ++j;
                    }
                }
                System.out.println("expl(" + this.domain.getVariable() + "!=" + i + ") is " + s);
            }
            ++i;
        }
    }

    public boolean controlNoExplanation(int index) {
        if (this.nbCulprits[index] > 0) {
            return false;
        }
        int i = 0;
        while (i < this.culpritStatus[index].length) {
            if (this.culpritStatus[index][i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean controlOneExplanation(int index, Variable recentPastVariable) {
        if (this.nbCulprits[index] == -1) {
            return this.controlNoExplanation(index);
        }
        if (this.nbCulprits[index] == 0) {
            System.out.println("Index " + index + " from " + this.domain + " should have one explanation");
            return false;
        }
        return this.controlExplanationOf(index, recentPastVariable);
    }

    public boolean controlOneExplanation(int index) {
        return this.controlOneExplanation(index, null);
    }

    public boolean controlExplanationOf(int index, Variable recentPastVariable) {
        if (this.nbCulprits[index] == -1) {
            return this.controlNoExplanation(index);
        }
        int cpt = 0;
        int i = 0;
        while (i < this.culpritStatus[index].length) {
            if (this.culpritStatus[index][i]) {
                if (!this.variables[i].isAssigned() && this.variables[i] != recentPastVariable) {
                    System.out.println("Index " + index + " from " + this.domain + " explained by a future variable " + this.variables[i]);
                    return false;
                }
                boolean found = false;
                int j = 0;
                while (!found && j < this.nbCulprits[index]) {
                    if (this.culprits[index][j] == this.variables[i]) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    System.out.println("Index " + index + " from " + this.domain + " explained by a future variable " + this.variables[i]);
                    return false;
                }
                ++cpt;
            }
            ++i;
        }
        if (cpt != this.nbCulprits[index]) {
            System.out.println("Index " + index + " from " + this.domain + " has incoherent explanation");
            return false;
        }
        return true;
    }

    public boolean controlExplanationOf(int index) {
        return this.controlExplanationOf(index, null);
    }

    public boolean controlAllExplanations() {
        int index = 0;
        if (index < this.culpritStatus.length) {
            if (!this.domain.hasIndex(index)) {
                return this.controlOneExplanation(index);
            }
            return this.controlNoExplanation(index);
        }
        return true;
    }
}

