/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.valueOrdering.dynamic;

import abscon.constraints.Constraint;
import abscon.constraints.DomainManager;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.heuristics.valueOrdering.dynamic.DynamicValueOrderingHeuristic;
import abscon.problem.Variable;

public class ONbConflicts
extends DynamicValueOrderingHeuristic {
    private int variant = 1;

    public void attachTo(Variable variable) {
        super.attachTo(variable);
        Constraint[] constraintArray = variable.getProblem().getConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getConflictsStructure() == null) {
                throw new IncompatiblePropertiesException();
            }
            ++n;
        }
    }

    public void evaluate(int index) {
        double cpt = 0.0;
        Constraint[] constraintArray = this.variable.getInvolvingConstraints();
        int n = 0;
        int n2 = constraintArray.length;
        while (n < n2) {
            Constraint constraint = constraintArray[n];
            if (constraint.getNbFreeVariables() != 1) {
                int variablePosition = constraint.getPositionOf(this.variable);
                int nb = constraint.getConflictsStructure().getNbInitialConflictsFor(variablePosition, index);
                if (this.variant == 0) {
                    cpt += (double)nb;
                } else {
                    DomainManager dm = constraint.getDomainManager();
                    cpt += (double)nb * dm.getDCurrentDomainSizeExcluding(variablePosition) / dm.getDMaximumDomainSizeExcluding(variablePosition);
                }
            }
            ++n;
        }
        this.currentEvaluations[index] = cpt;
    }
}

