/*
 * Decompiled with CFR 0.152.
 */
package abscon.heuristics.valueOrdering;

import abscon.exceptions.IncompatiblePropertiesException;
import abscon.heuristics.valueOrdering.ValueOrderingHeuristic;
import abscon.problem.domains.Domain;
import abscon.solvers.systematicSolvers.IterativeSystematicSolver;
import abscon.tools.Tools;
import abscon.tools.absconParameters.ConfigurationManager;

public abstract class SelectionManager {
    protected ValueOrderingHeuristic valueOrderingHeuristic;
    protected int[] selection;
    protected int nbElementsInSelection;
    protected int selectionCursor;
    protected int selectionWidth;

    public int[] getSelection() {
        return this.selection;
    }

    public int getSelectionWidth() {
        return this.selectionWidth;
    }

    public SelectionManager(ValueOrderingHeuristic valueOrderingHeuristic, int selectionWidth) {
        this.valueOrderingHeuristic = valueOrderingHeuristic;
        this.selectionWidth = selectionWidth == -1 ? valueOrderingHeuristic.getVariable().getDomain().getCurrentSize() : selectionWidth;
        this.selection = new int[this.selectionWidth];
        String solverClassName = ConfigurationManager.getString(valueOrderingHeuristic.getVariable().getProblem().getLevelInResolution(), "solver", "class");
        if (solverClassName.equals(Tools.getRelativeClassNameOf(IterativeSystematicSolver.class)) && this.selectionWidth != 1) {
            throw new IncompatiblePropertiesException();
        }
    }

    public abstract void performSelection();

    public boolean hasAnotherElementInSelection() {
        Domain domain = this.valueOrderingHeuristic.getVariable().getDomain();
        while (this.selectionCursor < this.nbElementsInSelection) {
            if (domain.hasIndex(this.selection[this.selectionCursor])) {
                return true;
            }
            ++this.selectionCursor;
        }
        return false;
    }

    public int getNextElementInSelection() {
        assert (this.selectionCursor < this.nbElementsInSelection);
        Domain domain = this.valueOrderingHeuristic.getVariable().getDomain();
        while (!domain.hasIndex(this.selection[this.selectionCursor])) {
            ++this.selectionCursor;
        }
        return this.selection[this.selectionCursor++];
    }
}

