/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.universal.evaluators;

import abscon.constraints.Constraint;
import abscon.constraints.universal.evaluators.BooleanType;
import abscon.constraints.universal.evaluators.Evaluator;
import abscon.constraints.universal.evaluators.IntegerType;
import abscon.constraints.universal.evaluators.arithmetic.AbsEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.AddEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.ArithmeticEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.DivEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.MaxEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.MinEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.ModEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.MulEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.NegEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.PowEvaluator;
import abscon.constraints.universal.evaluators.arithmetic.SubEvaluator;
import abscon.constraints.universal.evaluators.logical.AndEvaluator;
import abscon.constraints.universal.evaluators.logical.LogicalEvaluator;
import abscon.constraints.universal.evaluators.logical.NotEvaluator;
import abscon.constraints.universal.evaluators.logical.OrEvaluator;
import abscon.constraints.universal.evaluators.logical.XorEvaluator;
import abscon.constraints.universal.evaluators.relational.EqEvaluator;
import abscon.constraints.universal.evaluators.relational.GeEvaluator;
import abscon.constraints.universal.evaluators.relational.GtEvaluator;
import abscon.constraints.universal.evaluators.relational.LeEvaluator;
import abscon.constraints.universal.evaluators.relational.LtEvaluator;
import abscon.constraints.universal.evaluators.relational.NeEvaluator;
import abscon.constraints.universal.evaluators.terminal.FalseEvaluator;
import abscon.constraints.universal.evaluators.terminal.LongEvaluator;
import abscon.constraints.universal.evaluators.terminal.TrueEvaluator;
import abscon.constraints.universal.evaluators.terminal.VariableEvaluator;
import abscon.tools.Tools;
import abscon.tools.checker2006.problem.Domain;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationManager {
    protected List<Constraint> list = new LinkedList<Constraint>();
    private Evaluator[] evaluators;
    private int[] currentValues;
    private int[] shortCircuits;
    private boolean useShortCircuits = true;

    public Constraint getFirstAssociatedConstraint() {
        return this.list.get(0);
    }

    public void addFirstAssociatedConstraint(Constraint constraint) {
        assert (this.list.size() == 0);
        this.list.add(constraint);
        constraint.getProblem().incrementNbEvaluationManagers();
    }

    public void addAnotherAssociatedConstraint(Constraint constraint) {
        assert (this.list.size() > 0);
        this.list.add(constraint);
        constraint.getProblem().incrementNbSharedEvaluationManagers();
    }

    public boolean isSharedEvaluator() {
        return this.list.size() > 1;
    }

    public int getCurentValueOf(int variablePosition) {
        return this.currentValues[variablePosition];
    }

    private Evaluator buildEvaluator(String token) {
        Long l = Tools.isLong(token);
        if (l != null) {
            return new LongEvaluator(l);
        }
        if (token.startsWith("X")) {
            return new VariableEvaluator(this, Integer.parseInt(token.substring("X".length())));
        }
        if (token.equals("add")) {
            return new AddEvaluator();
        }
        if (token.equals("sub")) {
            return new SubEvaluator();
        }
        if (token.equals("div")) {
            return new DivEvaluator();
        }
        if (token.equals("mul")) {
            return new MulEvaluator();
        }
        if (token.equals("mod")) {
            return new ModEvaluator();
        }
        if (token.equals("abs")) {
            return new AbsEvaluator();
        }
        if (token.equals("neg")) {
            return new NegEvaluator();
        }
        if (token.equals("pow")) {
            return new PowEvaluator();
        }
        if (token.equals("min")) {
            return new MinEvaluator();
        }
        if (token.equals("max")) {
            return new MaxEvaluator();
        }
        if (token.equals("gt")) {
            return new GtEvaluator();
        }
        if (token.equals("ge")) {
            return new GeEvaluator();
        }
        if (token.equals("lt")) {
            return new LtEvaluator();
        }
        if (token.equals("le")) {
            return new LeEvaluator();
        }
        if (token.equals("eq")) {
            return new EqEvaluator();
        }
        if (token.equals("ne")) {
            return new NeEvaluator();
        }
        if (token.equals("true")) {
            return new TrueEvaluator();
        }
        if (token.equals("false")) {
            return new FalseEvaluator();
        }
        if (token.equals("or")) {
            return new OrEvaluator();
        }
        if (token.equals("xor")) {
            return new XorEvaluator();
        }
        if (token.equals("and")) {
            return new AndEvaluator();
        }
        if (token.equals("not")) {
            return new NotEvaluator();
        }
        throw new IllegalArgumentException("unknown token  " + token + " in the expression of a predicate");
    }

    private List<Evaluator> buildEvaluatorsFrom(String canonicalPostfixExpression) {
        LinkedList<Evaluator> collectedEvaluators = new LinkedList<Evaluator>();
        StringTokenizer st = new StringTokenizer(canonicalPostfixExpression);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            collectedEvaluators.add(this.buildEvaluator(token));
        }
        return collectedEvaluators;
    }

    private void dealWithShortCircuits() {
        this.shortCircuits = new int[this.evaluators.length];
        if (!this.useShortCircuits) {
            return;
        }
        this.useShortCircuits = false;
        int i = 0;
        while (i < this.evaluators.length - 1) {
            if (!(this.evaluators[i] instanceof ArithmeticEvaluator || this.evaluators[i] instanceof LongEvaluator || this.evaluators[i] instanceof VariableEvaluator)) {
                int j = i + 1;
                int nbStackedElements = 1;
                while (j < this.evaluators.length) {
                    if ((nbStackedElements += 1 - this.evaluators[j].getArity()) <= 1) break;
                    ++j;
                }
                if (j != i + 1) {
                    this.useShortCircuits = true;
                    if (this.evaluators[j] instanceof OrEvaluator) {
                        this.shortCircuits[i] = j + 1;
                    } else if (this.evaluators[j] instanceof AndEvaluator) {
                        this.shortCircuits[i] = -j - 1;
                    }
                }
            }
            ++i;
        }
        if (!this.useShortCircuits) {
            this.shortCircuits = null;
        }
    }

    public EvaluationManager(String universalPostfixExpression) {
        List<Evaluator> collectedEvaluators = this.buildEvaluatorsFrom(universalPostfixExpression);
        this.evaluators = collectedEvaluators.toArray(new Evaluator[0]);
        this.dealWithShortCircuits();
        Evaluator.checkStackSize(this.evaluators.length);
    }

    private int nextEvaluator(int i) {
        if (this.shortCircuits[i] > 0) {
            return Evaluator.getTopValue() == 1L ? this.shortCircuits[i] : i + 1;
        }
        return Evaluator.getTopValue() == 0L ? -this.shortCircuits[i] : i + 1;
    }

    public final boolean check(int[] values) {
        this.currentValues = values;
        Evaluator.resetTop();
        if (!this.useShortCircuits) {
            Evaluator[] evaluatorArray = this.evaluators;
            int n = 0;
            int n2 = evaluatorArray.length;
            while (n < n2) {
                Evaluator evaluator = evaluatorArray[n];
                evaluator.evaluate();
                ++n;
            }
        } else {
            int i = 0;
            while (i < this.evaluators.length) {
                this.evaluators[i].evaluate();
                if (this.shortCircuits[i] == 0) {
                    ++i;
                    continue;
                }
                i = this.nextEvaluator(i);
            }
        }
        assert (Evaluator.getTop() == 1) : "" + Evaluator.getTop();
        return Evaluator.getTopValue() == 1L;
    }

    public final boolean controlArityAndTypeOfExpression() {
        if (!(this.evaluators[this.evaluators.length - 1] instanceof BooleanType)) {
            return false;
        }
        int nbStackedElements = 0;
        int i = 0;
        while (i < this.evaluators.length) {
            nbStackedElements += 1 - this.evaluators[i].getArity();
            ++i;
        }
        if (nbStackedElements != 1) {
            return false;
        }
        boolean[] booleanTypes = new boolean[this.evaluators.length];
        int top = -1;
        int i2 = 0;
        while (i2 < this.evaluators.length) {
            int j;
            if (this.evaluators[i2].getArity() == 0) {
                booleanTypes[++top] = this.evaluators[i2] instanceof BooleanType;
            } else if (this.evaluators[i2] instanceof IntegerType) {
                j = 0;
                while (j < this.evaluators[i2].getArity()) {
                    if (booleanTypes[top]) {
                        return false;
                    }
                    --top;
                    ++j;
                }
                booleanTypes[++top] = false;
            } else {
                assert (this.evaluators[i2] instanceof BooleanType);
                if (this.evaluators[i2] instanceof LogicalEvaluator) {
                    j = 0;
                    while (j < this.evaluators[i2].getArity()) {
                        if (!booleanTypes[top]) {
                            return false;
                        }
                        --top;
                        ++j;
                    }
                    booleanTypes[++top] = true;
                } else {
                    j = 0;
                    while (j < this.evaluators[i2].getArity()) {
                        if (booleanTypes[top]) {
                            return false;
                        }
                        --top;
                        ++j;
                    }
                    booleanTypes[++top] = true;
                }
            }
            ++i2;
        }
        return true;
    }

    public boolean isGuaranteedToBeDivisionByZeroFree(Domain[] domains) {
        int i = 0;
        while (i < this.evaluators.length) {
            if (!(!(this.evaluators[i] instanceof DivEvaluator) && !(this.evaluators[i] instanceof ModEvaluator) || this.evaluators[i - 1] instanceof LongEvaluator && ((LongEvaluator)this.evaluators[i - 1]).getValue() != 0L || this.evaluators[i - 1] instanceof VariableEvaluator && !domains[((VariableEvaluator)this.evaluators[i - 1]).getPosition()].contains(0))) {
                System.out.println(this.evaluators[i - 1]);
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isGuaranteedToBeOverflowFree(int[] maximumAbsoluteValues) {
        long[] lstack = new long[this.evaluators.length];
        double[] dstack = new double[this.evaluators.length];
        int topL = 0;
        int topD = 0;
        int i = 0;
        while (i < this.evaluators.length) {
            if (this.evaluators[i] instanceof LongEvaluator) {
                lstack[topL++] = Math.abs(((LongEvaluator)this.evaluators[i]).getValue());
                dstack[topD++] = Math.abs(((LongEvaluator)this.evaluators[i]).getValue());
            } else if (this.evaluators[i] instanceof VariableEvaluator) {
                lstack[topL++] = maximumAbsoluteValues[((VariableEvaluator)this.evaluators[i]).getPosition()];
                dstack[topD++] = maximumAbsoluteValues[((VariableEvaluator)this.evaluators[i]).getPosition()];
            } else if (this.evaluators[i] instanceof TrueEvaluator) {
                lstack[topL++] = 1L;
                dstack[topD++] = 1.0;
            } else if (this.evaluators[i] instanceof FalseEvaluator) {
                lstack[topL++] = 0L;
                dstack[topD++] = 0.0;
            } else if (this.evaluators[i] instanceof AddEvaluator) {
                lstack[topL++] = lstack[--topL] + lstack[--topL];
                dstack[topD++] = dstack[--topD] + dstack[--topD];
            } else if (this.evaluators[i] instanceof SubEvaluator) {
                lstack[topL++] = lstack[--topL] + lstack[--topL];
                dstack[topD++] = dstack[--topD] + dstack[--topD];
            } else if (this.evaluators[i] instanceof MulEvaluator) {
                lstack[topL++] = lstack[--topL] * lstack[--topL];
                dstack[topD++] = dstack[--topD] * dstack[--topD];
            } else if (this.evaluators[i] instanceof PowEvaluator) {
                long toptop = lstack[--topL];
                long pretop = lstack[--topL];
                lstack[topL++] = (long)Math.pow(pretop, toptop);
                double toptopD = dstack[--topD];
                double pretopD = dstack[--topD];
                dstack[topD++] = Math.pow(pretopD, toptopD);
            } else if (this.evaluators[i] instanceof DivEvaluator) {
                --topL;
                --topD;
            } else if (this.evaluators[i] instanceof ModEvaluator) {
                lstack[topL - 2] = lstack[topL - 1];
                --topL;
                dstack[topD - 2] = dstack[topD - 1];
                --topD;
            } else if (this.evaluators[i].getArity() != 1) {
                if (this.evaluators[i] instanceof LogicalEvaluator) {
                    lstack[topL++] = Math.max(lstack[--topL], lstack[--topL]);
                    dstack[topD++] = Math.max(dstack[--topD], dstack[--topD]);
                } else {
                    lstack[topL++] = lstack[--topL] + lstack[--topL];
                    dstack[topD++] = dstack[--topD] + dstack[--topD];
                }
            }
            if ((double)lstack[topL - 1] != dstack[topD - 1] || Double.isInfinite(dstack[topD - 1])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

