/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.global;

import abscon.constraints.global.GlobalConstraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import java.util.Arrays;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class WeightedSumEqualTo
extends GlobalConstraint {
    private int[] coefficients;
    private int limit;

    public int[] getCoefficients() {
        return this.coefficients;
    }

    public int getLimit() {
        return this.limit;
    }

    public WeightedSumEqualTo(Problem problem, Variable[] variables) {
        super(problem, variables);
    }

    public WeightedSumEqualTo(Problem problem, Variable[] variables, int limit) {
        super(problem, variables);
        this.limit = limit;
        this.coefficients = new int[variables.length];
        Arrays.fill(this.coefficients, 1);
    }

    public WeightedSumEqualTo(Problem problem, Variable[] variables, int[] coeffs, int limit, boolean requiredClone) {
        super(problem, variables);
        if (!requiredClone) {
            this.coefficients = coeffs;
        } else {
            this.coefficients = new int[variables.length];
            int i = 0;
            while (i < this.coefficients.length) {
                this.coefficients[i] = coeffs[i];
                ++i;
            }
        }
        this.limit = limit;
    }

    protected boolean check(int[] values) {
        int sum = 0;
        int i = 0;
        while (i < this.coefficients.length) {
            sum += this.coefficients[i] * values[i];
            ++i;
        }
        return sum == this.limit;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        return "weightedSumEqualTo";
    }

    public void updateElement(Document document, Element constraintElement, boolean canonicalForm) {
        constraintElement.setAttribute("reference", "global:weightedSumEqualTo");
        Element parametersElement = document.createElement("parameters");
        Element list = document.createElement("list");
        String s = "";
        int i = 0;
        while (i < this.coefficients.length) {
            s = String.valueOf(s) + (i > 0 ? " " : "") + this.coefficients[i] + " " + this.involvedVariables[i].getName(canonicalForm);
            ++i;
        }
        list.setTextContent(s);
        parametersElement.appendChild(list);
        Element cst = document.createElement("cst");
        cst.setTextContent(String.valueOf(this.limit));
        parametersElement.appendChild(cst);
        constraintElement.appendChild(parametersElement);
    }
}

