/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.global;

import abscon.constants.Expr;
import abscon.constraints.Constraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.tools.elements.Elements;

public class CoverageConstraint
extends Constraint {
    int iCell;
    int jCell;
    int[] distances;
    int desiredCoverage;

    public void setCoordinates(int iCell, int jCell) {
        this.iCell = iCell;
        this.jCell = jCell;
    }

    public CoverageConstraint(Problem problem, Variable[] variables, int[] distances) {
        super(problem, variables);
        assert (variables.length == distances.length - 1);
        this.distances = distances;
        this.desiredCoverage = distances[distances.length - 1];
    }

    public boolean check(int[] values) {
        int cpt = 0;
        int i = 0;
        while (i < this.involvedVariables.length) {
            if (values[i] >= this.distances[i]) {
                ++cpt;
            }
            ++i;
        }
        if (this.desiredCoverage == 0) {
            return cpt == 0;
        }
        return cpt == this.desiredCoverage;
    }

    public void revise(PropagationTechnique propagationTechnique, Variable variable) {
        int min = 0;
        int max = 0;
        int i = 0;
        while (i < this.involvedVariables.length) {
            if (this.involvedVariables[i] != variable) {
                if (this.involvedVariables[i].getDomain().getFirstValidIndex() >= this.distances[i]) {
                    ++min;
                }
                if (this.involvedVariables[i].getDomain().getLastValidIndex() >= this.distances[i]) {
                    ++max;
                }
            }
            ++i;
        }
        Domain domain = variable.getDomain();
        Elements elements = domain.getElements();
        int position = this.getPositionOf(variable);
        int index = elements.getFirstPresent();
        while (index != -1) {
            if (index < this.distances[position]) {
                if (this.desiredCoverage > max || this.desiredCoverage < min) {
                    domain.removeElementAt(index, this);
                }
            } else if (this.desiredCoverage > max + 1 || this.desiredCoverage < min + 1) {
                domain.removeElementAt(index, this);
            }
            index = elements.getNextPresent(index);
        }
    }

    public int getOverCoverage() {
        if (this.desiredCoverage == 0) {
            return 0;
        }
        int cpt = 0;
        int i = 0;
        while (i < this.involvedVariables.length) {
            if (this.involvedVariables[i].getDomain().getFirstValidIndex() >= this.distances[i]) {
                ++cpt;
            }
            ++i;
        }
        return cpt >= this.desiredCoverage ? cpt - this.desiredCoverage : 0;
    }

    public void display() {
        super.display();
        System.out.println("  icell = " + this.iCell + " jCell = " + this.jCell);
        System.out.print("  distances = ");
        int i = 0;
        while (i < this.distances.length - 1) {
            System.out.print(String.valueOf(this.distances[i]) + " ");
            ++i;
        }
        System.out.println();
        System.out.println("  desired coverage = " + this.desiredCoverage);
    }

    public String[] getNamesOfConstants(int mode) {
        String[] names = new String[this.distances.length];
        int i = 0;
        while (i < names.length) {
            names[i] = mode == 2 ? "c" + i : String.valueOf(this.distances[i]);
            ++i;
        }
        return names;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        if (variableNames.length != constantNames.length - 1) {
            return "";
        }
        String s = "";
        int i = 0;
        while (i < variableNames.length) {
            s = String.valueOf(s) + Expr.gte(variableNames[i], constantNames[i]) + (i < variableNames.length - 1 ? " " : "");
            ++i;
        }
        return Expr.equ(Expr.add(s), constantNames[constantNames.length - 1]);
    }
}

