/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.global;

import abscon.constraints.Constraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import java.util.Arrays;

public class AllMaxOccurrences
extends Constraint {
    private int max;
    private int nbValues;
    protected int[] counters;

    public AllMaxOccurrences(Problem problem, Variable[] variables, int max, int nbValues) {
        super(problem, variables);
        this.max = max;
        this.nbValues = nbValues;
        this.counters = new int[nbValues];
    }

    protected boolean updateCountersFor(int index) {
        int n = index;
        this.counters[n] = this.counters[n] + 1;
        return this.counters[index] <= this.max;
    }

    protected final boolean check(int[] values) {
        Arrays.fill(this.counters, 0);
        int i = 0;
        while (i < values.length) {
            if (!this.updateCountersFor(values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

