/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.global;

import abscon.constants.XMLInstanceRepresentation;
import abscon.constraints.global.AllCompatible;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.forwardPropagationTechniques.ForwardPropagationTechnique;
import abscon.propagationTechniques.propagationSets.PropagationSet;
import abscon.tools.elements.Elements;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class AllDifferent
extends AllCompatible {
    private Map<Integer, Integer> map = new HashMap<Integer, Integer>();

    public AllDifferent(Problem problem, Variable[] variables) {
        super(problem, variables);
    }

    public boolean isGACGuaranteed() {
        return false;
    }

    public boolean canBeCurrentlyPropagated() {
        int nb = this.getNbFutureVariables();
        return nb > 0;
    }

    public void triggerUponBacktracking() {
    }

    public boolean isConsistent() {
        this.problem.getSolver().getCurrentPropagationTechnique();
        PropagationSet set = this.problem.getSolver().getCurrentPropagationTechnique().getPropagationSet();
        this.map.clear();
        int i = 0;
        while (i < this.involvedVariables.length) {
            if (this.involvedVariables[i].getDomain().getCurrentSize() == 1) {
                int value = this.involvedVariables[i].getDomain().getUniqueValue();
                Variable futureVariable = this.getFirstFutureVariable();
                while (futureVariable != null) {
                    Domain futureDomain;
                    int futureIndex;
                    if (futureVariable != this.involvedVariables[i] && (futureIndex = (futureDomain = futureVariable.getDomain()).toIndex(value)) >= 0 && futureDomain.hasIndex(futureIndex)) {
                        futureDomain.removeElementAt(futureIndex, this.involvedVariables);
                        if (futureDomain.getCurrentSize() == 0) {
                            ((ForwardPropagationTechnique)this.problem.getSolver().getCurrentPropagationTechnique()).incrementNbFailuresOf(this, futureVariable);
                            return false;
                        }
                        set.updateAfterEffectiveRevisionOf(this, futureVariable, 1);
                    }
                    futureVariable = this.getNextFutureVariableAfter(futureVariable);
                }
            }
            Domain domain = this.involvedVariables[i].getDomain();
            Elements elements = domain.getElements();
            int index = elements.getFirstPresent();
            while (index != -1) {
                int value = domain.toValue(index);
                this.map.put(value, value);
                index = elements.getNextPresent(index);
            }
            ++i;
        }
        this.domainManager.setNbRecentDomainRemovals(0);
        return true;
    }

    public boolean isConsistent(Variable variable) {
        if (variable.getDomain().getCurrentSize() == 1) {
            ForwardPropagationTechnique pt = (ForwardPropagationTechnique)this.problem.getSolver().getCurrentPropagationTechnique();
            int value = variable.getDomain().getUniqueValue();
            Variable futureVariable = this.getFirstFutureVariable();
            while (futureVariable != null) {
                Domain futureDomain;
                int futureIndex;
                if (futureVariable != variable && (futureIndex = (futureDomain = futureVariable.getDomain()).toIndex(value)) >= 0 && futureDomain.hasIndex(futureIndex)) {
                    futureDomain.removeElementAt(futureIndex, this.involvedVariables);
                    if (futureDomain.getCurrentSize() == 0) {
                        pt.incrementNbFailuresOf(this, futureVariable);
                        return false;
                    }
                    pt.getPropagationSet().updateAfterEffectiveRevisionOf(this, futureVariable, 1);
                }
                futureVariable = this.getNextFutureVariableAfter(futureVariable);
            }
        }
        this.map.clear();
        int nb = this.getNbPastVariables();
        Variable futureVariable = this.getFirstFutureVariable();
        while (futureVariable != null) {
            Domain domain = futureVariable.getDomain();
            Elements elements = domain.getElements();
            int index = elements.getFirstPresent();
            while (index != -1) {
                int value = domain.toValue(index);
                this.map.put(value, value);
                index = elements.getNextPresent(index);
            }
            if (this.map.size() + nb >= this.involvedVariables.length) {
                return true;
            }
            futureVariable = this.getNextFutureVariableAfter(futureVariable);
        }
        return this.map.size() + nb >= this.involvedVariables.length;
    }

    protected boolean isCompatible(Variable variable0, int value0, Variable variable1, int value1) {
        return value0 != value1;
    }

    protected Variable tryRemovalsFrom(Domain singletonDomain) {
        int value = singletonDomain.getUniqueValue();
        Variable futureVariable = this.getFirstFutureVariable();
        while (futureVariable != null) {
            int futureIndex;
            Domain futureDomain = futureVariable.getDomain();
            if (futureDomain != singletonDomain && (futureIndex = futureDomain.toIndex(value)) >= 0 && futureDomain.hasIndex(futureIndex)) {
                Variable v;
                futureDomain.removeElementAt(futureIndex, this.involvedVariables);
                if (futureDomain.getCurrentSize() == 0) {
                    return futureVariable;
                }
                if (futureDomain.getCurrentSize() == 1 && (v = this.tryRemovalsFrom(futureDomain)) != null) {
                    return v;
                }
            }
            futureVariable = this.getNextFutureVariableAfter(futureVariable);
        }
        return null;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        return "allDifferent";
    }

    public void updateElement(Document document, Element constraintElement, boolean canonicalForm) {
        constraintElement.setAttribute("reference", XMLInstanceRepresentation.getGlobalNameOf("allDifferent"));
    }
}

