/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.global;

import abscon.constraints.global.GlobalConstraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;

public abstract class AllCompatible
extends GlobalConstraint {
    public AllCompatible(Problem problem, Variable[] variables) {
        super(problem, variables);
    }

    protected abstract boolean isCompatible(Variable var1, int var2, Variable var3, int var4);

    protected boolean check(int[] values) {
        int i = 0;
        while (i < values.length - 1) {
            int j = i + 1;
            while (j < values.length) {
                if (!this.isCompatible(this.involvedVariables[i], values[i], this.involvedVariables[j], values[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    protected Variable tryRemovalsFrom(Domain singletonDomain) {
        int value = singletonDomain.getUniqueValue();
        Variable futureVariable = this.getFirstFutureVariable();
        while (futureVariable != null) {
            Domain futureDomain = futureVariable.getDomain();
            if (futureDomain != singletonDomain) {
                Variable v;
                int sizeBefore = futureDomain.getCurrentSize();
                int index = futureDomain.getFirstValidIndex();
                while (index != -1) {
                    int futureValue = futureDomain.toValue(index);
                    if (!this.isCompatible(singletonDomain.getVariable(), value, futureVariable, futureValue)) {
                        futureDomain.removeElementAt(index, this.involvedVariables);
                    }
                    index = futureDomain.getNextValidIndexAfter(index);
                }
                if (futureDomain.getCurrentSize() == 0) {
                    return futureVariable;
                }
                if (futureDomain.getCurrentSize() == 1 && futureDomain.getCurrentSize() != sizeBefore && (v = this.tryRemovalsFrom(futureDomain)) != null) {
                    return v;
                }
            }
            futureVariable = this.getNextFutureVariableAfter(futureVariable);
        }
        return null;
    }
}

