/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension.structures;

import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.Supports;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Supports2D
extends Supports {
    protected int[][][] positionsOfSupports;

    public int[] getBinarySupportsOf(int position, int index) {
        return this.positionsOfSupports[position][index];
    }

    public int getNbSupports(int position, int index) {
        return this.positionsOfSupports[position][index].length;
    }

    public int getFirstBinarySupport(int position, int index) {
        int[] positions = this.positionsOfSupports[position][index];
        if (positions.length == 0) {
            return -1;
        }
        return positions[0];
    }

    public int getNextBinarySupport(int position, int index, int current) {
        int[] positions = this.positionsOfSupports[position][index];
        int res = Arrays.binarySearch(positions, current);
        if (res >= 0) {
            return current;
        }
        int point = -res - 1;
        if (point == positions.length) {
            return -1;
        }
        return positions[point];
    }

    protected void buildStructures() {
        int j;
        Constraint constraint = this.getFirstAssociatedConstraint();
        List[][] tmp = new List[constraint.getNbInvolvedVariables()][];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = new List[constraint.getInvolvedVariable(i).getDomain().getMaximumSize()];
            j = 0;
            while (j < tmp[i].length) {
                tmp[i][j] = new ArrayList();
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.tuples.length) {
            j = 0;
            while (j < this.tuples[i].length) {
                tmp[j][this.tuples[i][j]].add(this.tuples[i]);
                ++j;
            }
            ++i;
        }
        this.positionsOfSupports = new int[constraint.getNbInvolvedVariables()][][];
        i = 0;
        while (i < this.positionsOfSupports.length) {
            this.positionsOfSupports[i] = new int[constraint.getInvolvedVariable(i).getDomain().getMaximumSize()][];
            j = 0;
            while (j < this.positionsOfSupports[i].length) {
                int k = i == 0 ? 1 : 0;
                this.positionsOfSupports[i][j] = new int[tmp[i][j].size()];
                int cpt = 0;
                Iterator it = tmp[i][j].iterator();
                while (it.hasNext()) {
                    this.positionsOfSupports[i][j][cpt++] = ((int[])it.next())[k];
                }
                ++j;
            }
            ++i;
        }
    }

    public Supports2D(Constraint constraint) {
        super(constraint);
    }

    public void displayExhaustively() {
        int i = 0;
        while (i < this.positionsOfSupports.length) {
            System.out.println("Variable " + this.getFirstAssociatedConstraint().getInvolvedVariable(i));
            int j = 0;
            while (j < this.positionsOfSupports[i].length) {
                System.out.print("  " + j + " :");
                int k = 0;
                while (k < this.positionsOfSupports[i][j].length) {
                    System.out.print(" " + this.positionsOfSupports[i][j][k]);
                    ++k;
                }
                System.out.println();
                ++j;
            }
            ++i;
        }
    }

    protected boolean controlOrder() {
        int i = 0;
        while (i < this.positionsOfSupports.length) {
            int j = 0;
            while (j < this.positionsOfSupports[i].length) {
                int k = 0;
                while (k < this.positionsOfSupports[i][j].length - 1) {
                    if (this.positionsOfSupports[i][j][k] >= this.positionsOfSupports[i][j][k + 1]) {
                        return false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

