/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension.structures;

import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.domains.Domain;

public class Optim2D
extends ExtensionStructure {
    protected int[] firsts0;
    protected int[] firsts1;
    protected int[][] nexts0;
    protected int[][] nexts1;

    public int getFirstBinarySupport(int position, int index) {
        return position == 0 ? this.firsts0[index] : this.firsts1[index];
    }

    public int getNextBinarySupport(int position, int index, int current) {
        int next;
        int n = next = position == 0 ? this.nexts0[index][current] : this.nexts1[index][current];
        if (next > 0) {
            return current;
        }
        if (next == 0) {
            return -1;
        }
        return -next;
    }

    private void updateNexts1() {
        int i = 0;
        while (i < this.nexts1.length) {
            int j = this.nexts1[i].length - 1;
            while (j >= 0 && this.nexts0[j][i] == 0) {
                --j;
            }
            int last = Integer.MAX_VALUE;
            while (j >= 0) {
                this.nexts1[i][j] = last;
                last = j--;
                while (j >= 0 && this.nexts0[j][i] == 0) {
                    this.nexts1[i][j] = -last;
                    --j;
                }
            }
            this.firsts1[i] = last == Integer.MAX_VALUE ? -1 : last;
            ++i;
        }
    }

    private void updateNexts0() {
        int i = 0;
        while (i < this.nexts0.length) {
            int j = this.nexts0[i].length - 1;
            while (j >= 0 && this.nexts0[i][j] == 0) {
                --j;
            }
            int last = Integer.MAX_VALUE;
            while (j >= 0) {
                this.nexts0[i][j] = last;
                last = j--;
                while (j >= 0 && this.nexts0[i][j] == 0) {
                    this.nexts0[i][j] = -last;
                    --j;
                }
            }
            this.firsts0[i] = last == Integer.MAX_VALUE ? -1 : last;
            ++i;
        }
    }

    public void setSupports(int[][] tuples, boolean allowedTuples) {
        int val;
        Constraint constraint = this.getFirstAssociatedConstraint();
        Domain domain0 = constraint.getInvolvedVariable(0).getDomain();
        Domain domain1 = constraint.getInvolvedVariable(1).getDomain();
        this.firsts0 = new int[domain0.getMaximumSize()];
        this.firsts1 = new int[domain1.getMaximumSize()];
        this.nexts0 = new int[domain0.getMaximumSize()][domain1.getMaximumSize()];
        this.nexts1 = new int[domain1.getMaximumSize()][domain0.getMaximumSize()];
        if (!allowedTuples) {
            int i = 0;
            while (i < this.nexts0.length) {
                int j = 0;
                while (j < this.nexts0[i].length) {
                    this.nexts0[i][j] = 1;
                    ++j;
                }
                ++i;
            }
        }
        int n = val = allowedTuples ? 1 : 0;
        if (constraint.getIndexValueSimilarity()) {
            int[][] nArray = tuples;
            int n2 = 0;
            int n3 = nArray.length;
            while (n2 < n3) {
                int[] t = nArray[n2];
                this.nexts0[t[0]][t[1]] = val;
                ++n2;
            }
        } else {
            int[][] nArray = tuples;
            int n4 = 0;
            int n5 = nArray.length;
            while (n4 < n5) {
                int[] t = nArray[n4];
                this.nexts0[domain0.toIndex((int)t[0])][domain1.toIndex((int)t[1])] = val;
                ++n4;
            }
            constraint.setIndexValueSimilarity(true);
        }
        this.updateNexts1();
        this.updateNexts0();
    }

    public Optim2D(Constraint constraint) {
        super(constraint);
        assert (constraint.getArity() == 2);
    }

    public final boolean check(int[] tuple) {
        return this.nexts0[tuple[0]][tuple[1]] > 0;
    }

    public boolean removeTuple(int[] tuple) {
        throw new MissingImplementationException();
    }

    public void displayExhaustively() {
        System.out.println("Dimension 0");
        int i = 0;
        while (i < this.nexts0.length) {
            System.out.print(String.valueOf(i) + " : first=" + this.firsts0[i]);
            System.out.print(" nexts=");
            int j = 0;
            while (j < this.nexts0[i].length) {
                System.out.print(String.valueOf(this.nexts0[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println("Dimension 1");
        int j = 0;
        while (j < this.nexts1[0].length) {
            System.out.print(String.valueOf(j) + " : first=" + this.firsts1[j]);
            System.out.print(" nexts=");
            int i2 = 0;
            while (i2 < this.nexts1.length) {
                System.out.print(String.valueOf(this.nexts1[i2][j]) + " ");
                ++i2;
            }
            System.out.println();
            ++j;
        }
        System.out.println();
    }
}

