/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension.structures;

import abscon.constraints.Constraint;
import abscon.exceptions.MissingImplementationException;
import abscon.exceptions.UnreachableCodeException;
import java.util.LinkedList;
import java.util.List;

public abstract class ExtensionStructure {
    protected List<Constraint> list = new LinkedList<Constraint>();
    protected int nbTuplesRemoved;

    public Constraint getFirstAssociatedConstraint() {
        return this.list.get(0);
    }

    private void addAFirstAssociatedConstraint(Constraint constraint) {
        assert (this.list.size() == 0);
        this.list.add(constraint);
        constraint.getProblem().incrementNbExtensionStructures();
    }

    public void addAnotherAssociatedConstraint(Constraint constraint) {
        assert (this.list.size() > 0);
        this.list.add(constraint);
        constraint.getProblem().incrementNbSharedExtensionStructures();
    }

    public boolean isSharedStructure() {
        return this.list.size() > 1;
    }

    public int getNbTuplesRemoved() {
        return this.nbTuplesRemoved;
    }

    public int isSymmetric() {
        return -10;
    }

    public abstract void setSupports(int[][] var1, boolean var2);

    public ExtensionStructure(Constraint constraint) {
        this.addAFirstAssociatedConstraint(constraint);
    }

    public int getFirstBinarySupport(int position, int index) {
        throw new MissingImplementationException();
    }

    public int[] getFirstSupport(int position, int index) {
        throw new MissingImplementationException();
    }

    public int getNextBinarySupport(int position, int index, int current) {
        throw new MissingImplementationException();
    }

    public int[] getNextSupport(int position, int index, int[] current) {
        throw new MissingImplementationException();
    }

    public boolean removeTuple(int[] tuple) {
        throw new UnreachableCodeException();
    }

    public abstract boolean check(int[] var1);

    public void displayExhaustively() {
    }
}

