/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension.structures;

import abscon.constraints.ConflictsStructure;
import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.constraints.universal.evaluators.EvaluationManager;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Problem;
import abscon.problem.domains.Domain;
import abscon.tools.BitManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class Bits
extends ExtensionStructure {
    private static Map<HashKey, long[]> map;
    private static HashKey hashKey;
    private long[][] supports0;
    private long[][] supports1;
    private boolean sharedSupports;
    private static int[] tmp;
    static int cpt;

    static {
        tmp = new int[2];
        cpt = 0;
    }

    public static void clearMap() {
        if (map != null) {
            map.clear();
        }
    }

    public long[][] getBinaryRepresentationOfSupportsOf(int position) {
        return position == 0 ? this.supports0 : this.supports1;
    }

    public long[] getBinaryRepresentationOfSupportsOf(int position, int index) {
        return position == 0 ? this.supports0[index] : this.supports1[index];
    }

    private void buildArrays() {
        Domain domain0 = this.getFirstAssociatedConstraint().getInvolvedVariable(0).getDomain();
        Domain domain1 = this.getFirstAssociatedConstraint().getInvolvedVariable(1).getDomain();
        int nbLongs = domain1.getMaximumSize() / 64 + (domain1.getMaximumSize() % 64 != 0 ? 1 : 0);
        this.supports0 = new long[domain0.getMaximumSize()][nbLongs];
        nbLongs = domain0.getMaximumSize() / 64 + (domain0.getMaximumSize() % 64 != 0 ? 1 : 0);
        this.supports1 = new long[domain1.getMaximumSize()][nbLongs];
    }

    protected void fillSupports0(int[][] tuples, boolean allowedTuples) {
        Constraint constraint = this.getFirstAssociatedConstraint();
        Domain domain0 = constraint.getInvolvedVariable(0).getDomain();
        Domain domain1 = constraint.getInvolvedVariable(1).getDomain();
        if (allowedTuples) {
            if (constraint.getIndexValueSimilarity()) {
                int[][] nArray = tuples;
                int n = 0;
                int n2 = nArray.length;
                while (n < n2) {
                    int[] tuple = nArray[n];
                    long[] lArray = this.supports0[tuple[0]];
                    int n3 = tuple[1] / 64;
                    lArray[n3] = lArray[n3] | BitManager.ONE_LONG_BIT_TO_1[tuple[1] % 64];
                    ++n;
                }
            } else {
                int[][] nArray = tuples;
                int n = 0;
                int n4 = nArray.length;
                while (n < n4) {
                    int[] tuple = nArray[n];
                    int val0 = domain0.toIndex(tuple[0]);
                    int val1 = domain1.toIndex(tuple[1]);
                    long[] lArray = this.supports0[val0];
                    int n5 = val1 / 64;
                    lArray[n5] = lArray[n5] | BitManager.ONE_LONG_BIT_TO_1[val1 % 64];
                    ++n;
                }
                constraint.setIndexValueSimilarity(true);
            }
        } else {
            long[] tuple;
            Object object = this.supports0;
            int n = 0;
            int n6 = ((long[][])object).length;
            while (n < n6) {
                long[] t = object[n];
                Arrays.fill(t, -1L);
                t[t.length - 1] = BitManager.buildAllLongBitsTo1Upto(domain1.getMaximumSize() % 64);
                ++n;
            }
            if (constraint.getIndexValueSimilarity()) {
                object = tuples;
                n = 0;
                n6 = ((long[][])object).length;
                while (n < n6) {
                    tuple = object[n];
                    long[] lArray = this.supports0[tuple[0]];
                    long l = tuple[1] / 64;
                    lArray[l] = lArray[l] & BitManager.ONE_LONG_BIT_TO_0[tuple[1] % 64];
                    ++n;
                }
            } else {
                object = tuples;
                n = 0;
                n6 = ((long[][])object).length;
                while (n < n6) {
                    tuple = object[n];
                    int val0 = domain0.toIndex((int)tuple[0]);
                    int val1 = domain1.toIndex((int)tuple[1]);
                    long[] lArray = this.supports0[val0];
                    int n7 = val1 / 64;
                    lArray[n7] = lArray[n7] & BitManager.ONE_LONG_BIT_TO_0[val1 % 64];
                    ++n;
                }
                constraint.setIndexValueSimilarity(true);
            }
        }
    }

    protected void fillSupports1() {
        int i = 0;
        while (i < this.supports0.length) {
            int iByte = i / 64;
            int iPos = i % 64;
            int j = 0;
            while (j < this.supports0[i].length) {
                long support = this.supports0[i][j];
                int k = 0;
                while (k < Math.min(64, this.supports1.length - j * 64)) {
                    if ((support & BitManager.ONE_LONG_BIT_TO_1[k]) != 0L) {
                        long[] lArray = this.supports1[j * 64 + k];
                        int n = iByte;
                        lArray[n] = lArray[n] | BitManager.ONE_LONG_BIT_TO_1[iPos];
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void saveSpace(long[][] supports, int id) {
        Problem problem = this.getFirstAssociatedConstraint().getProblem();
        int i = 0;
        while (i < supports.length) {
            if (hashKey == null) {
                hashKey = new HashKey();
            }
            hashKey.t = supports[i];
            long[] tt = map.get(hashKey);
            if (tt == null) {
                map.put(hashKey, supports[i]);
                hashKey = null;
            } else {
                supports[i] = tt;
                problem.incrementNbSharedBinaryRepresentations();
            }
            ++i;
        }
    }

    private void saveSpace() {
        if (!((Constraint)this.list.get(0)).getProblem().getShareSupportsOfBits()) {
            return;
        }
        if (map == null) {
            map = new HashMap<HashKey, long[]>(2000);
        }
        Problem problem = this.getFirstAssociatedConstraint().getProblem();
        int nbSharedRepresentationsBefore = problem.getNbSharedBinaryRepresentations();
        this.saveSpace(this.supports0, 1);
        this.saveSpace(this.supports1, 0);
        this.sharedSupports = problem.getNbSharedBinaryRepresentations() - nbSharedRepresentationsBefore > 0;
    }

    public void setSupports(int[][] tuples, boolean allowedTuples) {
        this.buildArrays();
        this.fillSupports0(tuples, allowedTuples);
        this.fillSupports1();
        this.saveSpace();
    }

    public void setSupports(String canonicalPredicate) {
        Constraint constraint = this.getFirstAssociatedConstraint();
        this.buildArrays();
        ConflictsStructure conflictsStructure = constraint.getConflictsStructure();
        int[][] nbConflicts = conflictsStructure.getNbConflicts();
        EvaluationManager evaluationManager = new EvaluationManager(canonicalPredicate);
        int cpt = 0;
        Domain domain0 = constraint.getInvolvedVariable(0).getDomain();
        Domain domain1 = constraint.getInvolvedVariable(1).getDomain();
        int i = 0;
        while (i < domain0.getMaximumSize()) {
            Bits.tmp[0] = domain0.toValue(i);
            int j = 0;
            while (j < domain1.getMaximumSize()) {
                Bits.tmp[1] = domain1.toValue(j);
                ++cpt;
                if (evaluationManager.check(tmp)) {
                    long[] lArray = this.supports0[i];
                    int n = j / 64;
                    lArray[n] = lArray[n] | BitManager.ONE_LONG_BIT_TO_1[j % 64];
                    long[] lArray2 = this.supports1[j];
                    int n2 = i / 64;
                    lArray2[n2] = lArray2[n2] | BitManager.ONE_LONG_BIT_TO_1[i % 64];
                } else {
                    int[] nArray = nbConflicts[0];
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = nbConflicts[1];
                    int n3 = j;
                    nArray2[n3] = nArray2[n3] + 1;
                }
                ++j;
            }
            ++i;
        }
        constraint.getProblem().incrementNbConvertConstraintsChecksOf(cpt);
        constraint.setIndexValueSimilarity(true);
        this.saveSpace();
    }

    public Bits(Constraint constraint) {
        super(constraint);
        assert (constraint.getArity() == 2);
    }

    public final boolean check(int[] tuple) {
        return (this.supports0[tuple[0]][tuple[1] / 64] & BitManager.ONE_LONG_BIT_TO_1[tuple[1] % 64]) != 0L;
    }

    public boolean removeTuple(int[] tuple) {
        if (this.isSharedStructure() || this.sharedSupports) {
            throw new IncompatiblePropertiesException();
        }
        if ((this.supports0[tuple[0]][tuple[1] / 64] & BitManager.ONE_LONG_BIT_TO_1[tuple[1] % 64]) == 0L) {
            return false;
        }
        assert (this.supports1 == null || (this.supports1[tuple[1]][tuple[0] / 64] & BitManager.ONE_LONG_BIT_TO_1[tuple[0] % 64]) != 0L);
        long[] lArray = this.supports0[tuple[0]];
        int n = tuple[1] / 64;
        lArray[n] = lArray[n] & BitManager.ONE_LONG_BIT_TO_0[tuple[1] % 64];
        if (this.supports1 != null) {
            long[] lArray2 = this.supports1[tuple[1]];
            int n2 = tuple[0] / 64;
            lArray2[n2] = lArray2[n2] & BitManager.ONE_LONG_BIT_TO_0[tuple[0] % 64];
        }
        ++this.nbTuplesRemoved;
        return true;
    }

    public void displayExhaustively() {
        Constraint constraint = this.getFirstAssociatedConstraint();
        System.out.println("Bits of " + constraint);
        System.out.println("  support0");
        int i = 0;
        while (i < this.supports0.length) {
            System.out.println("    " + i + " : " + BitManager.decrypt(this.supports0[i], constraint.getInvolvedVariable(1).getDomain().getMaximumSize()));
            ++i;
        }
        if (this.supports1 != null) {
            System.out.println(" support1");
            i = 0;
            while (i < this.supports1.length) {
                System.out.println("    " + i + " : " + BitManager.decrypt(this.supports1[i], constraint.getInvolvedVariable(0).getDomain().getMaximumSize()));
                ++i;
            }
        }
    }

    class HashKey {
        private long[] t;

        HashKey() {
        }

        public int hashCode() {
            return Arrays.hashCode(this.t);
        }

        public boolean equals(Object object) {
            return Arrays.equals(this.t, ((HashKey)object).t);
        }
    }
}

