/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension;

import abscon.constraints.Constraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.problem.Problem;
import abscon.problem.Variable;

public class SoftExtensionConstraint
extends Constraint {
    private int mode = 1;
    private int[][] tuples;
    private long defaultCost;

    public long getDefaultCost() {
        return this.defaultCost;
    }

    protected ExtensionStructure buildExtensionStructure() {
        return null;
    }

    public SoftExtensionConstraint(Problem problem, Variable[] variables) {
        super(problem, variables);
    }

    public SoftExtensionConstraint(Problem problem, Variable[] variables, int[][] tuples, long defaultCost) {
        this(problem, variables);
        this.tuples = tuples;
        this.defaultCost = defaultCost;
    }

    public boolean canBeDefinedByAPredicate() {
        return false;
    }

    public String getStringListOfTuples() {
        StringBuffer sb = new StringBuffer();
        if (this.tuples.length == 0) {
            sb.append("|");
            return sb.append("#soft" + this.tuples.length).toString();
        }
        if (this.mode == 0) {
            int i = 0;
            while (i < this.tuples.length) {
                if (i != 0) {
                    sb.append("|");
                }
                int j = 0;
                while (j < this.tuples[i].length - 1) {
                    sb.append(this.tuples[i][j]);
                    sb.append(" ");
                    ++j;
                }
                sb.append(this.tuples[i][this.tuples[i].length - 1]);
                ++i;
            }
            sb.append("|");
            return sb.append("#soft" + this.tuples.length).toString();
        }
        int weightPosition = this.tuples[0].length - 1;
        int currentWeigth = -1;
        int i = 0;
        while (i < this.tuples.length) {
            if (i != 0) {
                sb.append("|");
            }
            if (this.tuples[i][weightPosition] != currentWeigth) {
                currentWeigth = this.tuples[i][weightPosition];
                sb.append("c" + currentWeigth + " ");
            }
            int j = 0;
            while (j < this.tuples[i].length - 2) {
                sb.append(this.tuples[i][j]);
                sb.append(" ");
                ++j;
            }
            sb.append(this.tuples[i][this.tuples[i].length - 2]);
            ++i;
        }
        sb.append("|");
        return sb.append("#soft" + this.tuples.length).toString();
    }
}

