/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.extension;

import abscon.constraints.extension.ExtensionConstraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.constraints.extension.structures.Supports2D;
import abscon.exceptions.IncompatiblePropertiesException;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.tools.absconParameters.ConfigurationManager;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public final class ExtensionConstraintABinary
extends ExtensionConstraint {
    private int type;
    private boolean optim;
    private Supports2D supps;

    protected ExtensionStructure buildExtensionStructure() {
        this.type = ConfigurationManager.getInt(this.problem.getLevelInResolution(), "problem/extension", "type");
        assert (this.type == 1 || this.type == 3);
        this.optim = ConfigurationManager.getBoolean(this.problem.getLevelInResolution(), "problem/extension", "optim2D");
        this.supps = new Supports2D(this);
        return this.supps;
    }

    private void manageSharing() {
        ExtensionConstraintABinary constraint = (ExtensionConstraintABinary)this.extensionStructure.getFirstAssociatedConstraint();
        if (constraint != this) {
            this.type = constraint.type;
            this.optim = constraint.optim;
            this.supps = constraint.supps;
        }
    }

    public void setSupports(int[][] tuples, boolean allowedTuples, String key) {
        if (this.involvedVariables.length != 2 || !allowedTuples) {
            throw new IncompatiblePropertiesException();
        }
        super.setSupports(tuples, allowedTuples, key);
        this.manageSharing();
    }

    public void setSupports(String canonicalPredicate, String key) {
        super.setSupports(canonicalPredicate, key);
        this.manageSharing();
    }

    public ExtensionConstraintABinary(Problem problem, Variable[] variables) {
        super(problem, variables);
        if (variables.length != 2) {
            throw new IncompatiblePropertiesException();
        }
    }

    private int computeStartingPosition(int[] supports, int current) {
        int res = Arrays.binarySearch(supports, current);
        if (res >= 0) {
            return res;
        }
        return -res - 1;
    }

    private final boolean seekSupportS(int variablePosition, int index, int[] tuple, boolean another) {
        int start;
        int brotherPosition = variablePosition == 0 ? 1 : 0;
        Elements brotherElements = this.involvedVariables[brotherPosition].getDomain().getElements();
        int[] supports = this.supps.getBinarySupportsOf(variablePosition, index);
        int i = start = another ? this.computeStartingPosition(supports, tuple[brotherPosition] + 1) : 0;
        while (i < supports.length) {
            this.problem.incrementNbConstraintChecks();
            if (this.optim && supports[i] > brotherElements.getLastPresent()) {
                return false;
            }
            if (brotherElements.isPresent(supports[i])) {
                tuple[brotherPosition] = supports[i];
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean seekSupport(int variablePosition, int index, int[] tuple) {
        tuple[variablePosition] = index;
        if (this.type == 1 || this.domainManager.getDCurrentDomainSizeExcluding(variablePosition) > (double)this.supps.getNbSupports(variablePosition, index)) {
            return this.seekSupportS(variablePosition, index, tuple, false);
        }
        assert (this.type == 3);
        return super.seekSupport(variablePosition, index, tuple);
    }

    public final boolean seekAnotherSupport(int variablePosition, int index, int[] tuple) {
        if (this.type == 1 || this.domainManager.getDCurrentDomainSizeExcluding(variablePosition) > (double)this.supps.getNbSupports(variablePosition, index)) {
            return this.seekSupportS(variablePosition, index, tuple, true);
        }
        assert (this.type == 3);
        return super.seekAnotherSupport(variablePosition, index, tuple);
    }
}

