/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.binary;

import abscon.constraints.binary.BinaryConstraint;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.tools.elements.Elements;
import java.util.Arrays;

public class SplittingConstraint
extends BinaryConstraint {
    public static int nbSplits = 0;
    private int median = -1;
    private int[] nbSupports;
    private int[] tmp;
    int[] values = new int[2];

    public void split() {
        ++nbSplits;
        int cpt = 0;
        int i = 0;
        while (i < this.nbSupports.length) {
            if (this.involvedVariables[0].getDomain().hasIndex(i)) {
                this.nbSupports[i] = this.involvedVariables[0].computeNbSupportsFor(i);
                this.tmp[cpt++] = this.nbSupports[i];
            } else {
                this.nbSupports[i] = -1;
            }
            ++i;
        }
        Arrays.sort(this.tmp, 0, cpt);
        this.median = this.tmp[cpt / 2];
        System.out.println(" split " + this + " number " + nbSplits);
        this.displaySplit();
    }

    private void displaySplitPart(int part) {
        System.out.println("Split part " + part);
        this.values[1] = part;
        this.involvedVariables[0].getDomain().display();
        Elements elements = this.involvedVariables[0].getDomain().getElements();
        int index = elements.getFirstPresent();
        while (index != -1) {
            this.values[0] = index;
            if (this.check(this.values)) {
                System.out.print(" " + index);
            }
            index = elements.getNextPresent(index);
        }
        System.out.println();
    }

    private void displaySplit() {
        this.displaySplitPart(0);
        this.displaySplitPart(1);
        System.out.println();
    }

    public SplittingConstraint(Problem problem, Variable[] variables) {
        super(problem, variables);
        this.indexValueSimilarity = true;
        this.nbSupports = new int[this.involvedVariables[0].getDomain().getMaximumSize()];
        this.tmp = new int[this.involvedVariables[0].getDomain().getMaximumSize()];
    }

    public final boolean check(int[] values) {
        if (values[1] == 0) {
            return values[0] < this.nbSupports.length / 2;
        }
        return values[0] >= this.nbSupports.length / 2;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        return "Splliting constraint";
    }
}

