/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.binary;

import abscon.constants.Expr;
import abscon.constraints.binaryWithInteger.BinaryConstraintWithInteger;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;

public class QueenConstraint
extends BinaryConstraintWithInteger {
    public QueenConstraint(Problem problem, Variable[] variables, int value) {
        super(problem, variables, value);
        assert (value == Math.abs(variables[0].getId() - variables[1].getId()));
    }

    public boolean check(int[] values) {
        return values[0] != values[1] && Math.abs(values[0] - values[1]) != this.value;
    }

    private boolean potentialRemovalOf(int index, Domain domain) {
        if (domain.hasIndex(index)) {
            domain.removeElementAt(index, this.involvedVariables);
            if (domain.getCurrentSize() == 0) {
                return false;
            }
        }
        return true;
    }

    protected Variable tryRemovalsFrom(Domain singletonDomain, Domain futureDomain) {
        int index = singletonDomain.getFirstValidIndex();
        if (!this.potentialRemovalOf(index, futureDomain)) {
            return futureDomain.getVariable();
        }
        if ((index -= this.value) >= 0 && !this.potentialRemovalOf(index, futureDomain)) {
            return futureDomain.getVariable();
        }
        if ((index += 2 * this.value) < futureDomain.getMaximumSize() && !this.potentialRemovalOf(index, futureDomain)) {
            return futureDomain.getVariable();
        }
        return null;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        String abs = Expr.abs(Expr.sub(variableNames[0], variableNames[1]));
        return Expr.and(Expr.diff(variableNames[0], variableNames[1]), Expr.diff(abs, constantNames[0]));
    }
}

