/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.binary;

import abscon.constants.Expr;
import abscon.constraints.binaryWithInteger.BinaryConstraintWithInteger;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;

public class KnightMoveConstraint
extends BinaryConstraintWithInteger {
    public KnightMoveConstraint(Problem problem, Variable[] variables, int value) {
        super(problem, variables, value);
    }

    private boolean isKnightMove(int value0, int value1) {
        int rowDistance = Math.abs(value0 / this.value - value1 / this.value);
        int columnDistance = Math.abs(value0 % this.value - value1 % this.value);
        return rowDistance == 1 && columnDistance == 2 || rowDistance == 2 && columnDistance == 1;
    }

    protected boolean check(int[] values) {
        return this.isKnightMove(values[0], values[1]);
    }

    protected Variable tryRemovalsFrom(Domain singletonDomain, Domain futureDomain) {
        int singletonValue = singletonDomain.getUniqueValue();
        int index = futureDomain.getFirstValidIndex();
        while (index != -1) {
            if (!this.isKnightMove(futureDomain.toValue(index), singletonValue)) {
                futureDomain.removeElementAt(index, this.involvedVariables);
            }
            index = futureDomain.getNextValidIndexAfter(index);
        }
        if (futureDomain.isEmpty()) {
            return futureDomain.getVariable();
        }
        return null;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        if (variableNames.length != 2 || constantNames.length != 1) {
            return null;
        }
        return Expr.function("KnightMove", variableNames[0], variableNames[1], constantNames[0]);
    }

    public String getPredicateDefinition() {
        String[] variableNames = this.getNamesOfVariables(2);
        String[] constantNames = this.getNamesOfConstants(2);
        String rowDistance = Expr.abs(Expr.sub(Expr.div(variableNames[0], constantNames[0]), Expr.div(variableNames[1], constantNames[0])));
        String columnDistance = Expr.abs(Expr.sub(Expr.mod(variableNames[0], constantNames[0]), Expr.mod(variableNames[1], constantNames[0])));
        String sum = Expr.add(Expr.pow(rowDistance, "2"), Expr.pow(columnDistance, "2"));
        return Expr.equ(sum, "5");
    }
}

