/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.binary;

import abscon.constants.Expr;
import abscon.constraints.binary.BinaryConstraint;
import abscon.problem.Problem;
import abscon.problem.Variable;

public class DifferentSquare
extends BinaryConstraint {
    private int size;
    private int id;

    public DifferentSquare(Problem problem, Variable[] variables, int size, int id) {
        super(problem, variables);
        this.size = size;
        this.id = id;
        assert (id == this.involvedVariables[0].getId());
    }

    protected boolean check(int[] values) {
        return values[0] != values[1] % this.size || this.id != values[1] / this.size;
    }

    public String[] getNamesOfConstants(int mode) {
        String[] constants = new String[]{mode == 2 ? "c1" : String.valueOf(this.size), mode == 2 ? "c2" : String.valueOf(this.id)};
        return constants;
    }

    public static String getPredicateExpression(String[] variableNames, String[] constantNames) {
        if (variableNames.length != 2 || constantNames.length != 2) {
            return null;
        }
        return Expr.function("DifferentSquare", new String[]{variableNames[0], variableNames[1], constantNames[0], constantNames[1]});
    }

    public String getPredicateDefinition() {
        String[] variableNames = this.getNamesOfVariables(2);
        String[] constantNames = this.getNamesOfConstants(2);
        String diff1 = Expr.diff(variableNames[0], Expr.mod(variableNames[1], constantNames[0]));
        String diff2 = Expr.diff(constantNames[1], Expr.div(variableNames[1], constantNames[0]));
        return Expr.or(diff1, diff2);
    }
}

