/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints.binary;

import abscon.constraints.Constraint;
import abscon.exceptions.MissingImplementationException;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;

public abstract class BinaryConstraint
extends Constraint {
    public BinaryConstraint(Problem problem, Variable[] variables) {
        super(problem, variables);
        if (variables.length != 2) {
            throw new IllegalArgumentException("binary constraint " + this.getClass().getName() + " built with " + variables.length + " variables");
        }
    }

    protected Variable tryRemovalsFrom(Domain singletonDomain, Domain futureDomain) {
        throw new MissingImplementationException("class " + this.getClass().getName());
    }

    public Variable isSpecificIncoherent() {
        Variable inconsistentVariable;
        Domain domain0 = this.involvedVariables[0].getDomain();
        Domain domain1 = this.involvedVariables[1].getDomain();
        if (this.involvedVariables[1].isFuture() && domain0.getCurrentSize() == 1 && this.domainManager.hasRecentReducedDomain(0) && (inconsistentVariable = this.tryRemovalsFrom(domain0, domain1)) != null) {
            return inconsistentVariable;
        }
        if (this.involvedVariables[0].isFuture() && domain1.getCurrentSize() == 1 && this.domainManager.hasRecentReducedDomain(1) && (inconsistentVariable = this.tryRemovalsFrom(domain1, domain0)) != null) {
            return inconsistentVariable;
        }
        return null;
    }
}

