/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints;

import abscon.constraints.Constraint;
import abscon.constraints.TupleManager;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;

public final class FullConflictManager {
    public static final int LIMIT_DOMAIN = 1000000;
    private Constraint constraint;
    private int[] nbMaxConflicts;
    private int[][] nbConflicts;
    private boolean initialized;
    private int[][] covering;
    private int[] tmp = new int[3];
    private boolean sharedStructures;

    public FullConflictManager(Constraint constraint) {
        this.constraint = constraint;
    }

    public FullConflictManager(Constraint constraint, FullConflictManager conflictManager) {
        this(constraint);
        this.sharedStructures = true;
        conflictManager.sharedStructures = true;
        this.nbConflicts = conflictManager.nbConflicts;
        this.nbMaxConflicts = conflictManager.nbMaxConflicts;
        this.covering = conflictManager.covering;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public int[][] getNbConflicts() {
        return this.nbConflicts;
    }

    public int getNbInitialConflictsFor(int position, int index) {
        if (!this.initialized) {
            return -1;
        }
        return this.nbConflicts[position][index];
    }

    public void buildStructures() {
        this.nbConflicts = new int[this.constraint.getNbInvolvedVariables()][];
        this.nbMaxConflicts = new int[this.constraint.getNbInvolvedVariables()];
        this.covering = new int[this.constraint.getNbInvolvedVariables()][];
        int i = 0;
        while (i < this.nbConflicts.length) {
            this.nbConflicts[i] = new int[this.constraint.getInvolvedVariable(i).getDomain().getMaximumSize()];
            ++i;
        }
    }

    public void fixNbMaxConflictsAndCovering() {
        int i = 0;
        while (i < this.nbMaxConflicts.length) {
            int max = -1;
            int cpt = 0;
            int j = 0;
            while (j < this.nbConflicts[i].length) {
                if (this.nbConflicts[i][j] > max) {
                    max = this.nbConflicts[i][j];
                }
                if (this.nbConflicts[i][j] == 0 && this.constraint.getInvolvedVariable(i).getDomain().hasIndex(j)) {
                    if (cpt < this.tmp.length) {
                        this.tmp[cpt++] = j;
                    } else {
                        this.tmp[cpt - 1] = j;
                    }
                }
                ++j;
            }
            this.nbMaxConflicts[i] = max;
            this.covering[i] = new int[cpt];
            j = 0;
            while (j < this.covering[i].length) {
                this.covering[i][j] = this.tmp[j];
                ++j;
            }
            ++i;
        }
    }

    public void initializeFrom(int[][] tuples, boolean allowedTuples) {
        int j;
        long sizeL;
        if (this.constraint.getProblem().getResolution() != null && this.constraint.getProblem().getResolution().isSpaceReductionMode()) {
            return;
        }
        if (allowedTuples && ((sizeL = this.constraint.getDomainManager().getCurrentDomainSize()) == -1L || (long)((int)sizeL) != sizeL)) {
            return;
        }
        this.buildStructures();
        int i = 0;
        while (i < tuples.length) {
            j = 0;
            while (j < tuples[i].length) {
                int[] nArray = this.nbConflicts[j];
                int n = this.constraint.getInvolvedVariable(j).getDomain().toIndex(tuples[i][j]);
                nArray[n] = nArray[n] + 1;
                ++j;
            }
            ++i;
        }
        if (allowedTuples) {
            i = 0;
            while (i < this.nbConflicts.length) {
                j = 0;
                while (j < this.nbConflicts[i].length) {
                    this.nbConflicts[i][j] = (int)this.constraint.getDomainManager().getCurrentDomainSizeExcluding(i) - this.nbConflicts[i][j];
                    ++j;
                }
                ++i;
            }
        }
        this.fixNbMaxConflictsAndCovering();
    }

    private boolean usePrecomputedNumberOfConflicts() {
        int firstIndex;
        Variable firstVariable = this.constraint.getInvolvedVariable(0);
        return this.constraint.getNbMaxConflictsUpperBoundFor(firstVariable, firstIndex = firstVariable.getDomain().getFirstValidIndex()) != -10;
    }

    public void initialize() {
        long sizeL;
        if (this.constraint.getArity() > 2 && ((sizeL = this.constraint.getDomainManager().getCurrentDomainSize()) == -1L || sizeL > 1000000L)) {
            return;
        }
        this.buildStructures();
        if (this.usePrecomputedNumberOfConflicts()) {
            int i = 0;
            while (i < this.nbConflicts.length) {
                Variable variable = this.constraint.getInvolvedVariable(i);
                int j = 0;
                while (j < this.nbConflicts[i].length) {
                    this.nbConflicts[i][j] = this.constraint.getNbMaxConflictsUpperBoundFor(variable, j);
                    ++j;
                }
                ++i;
            }
        } else {
            TupleManager assistant = this.constraint.getTupleManager();
            int[] tuple = assistant.getLocalTuple();
            assistant.setFirstTupleFromScratch(tuple);
            do {
                if (this.constraint.checkCurrentTupleOfAssistant()) continue;
                int i = 0;
                while (i < tuple.length) {
                    int[] nArray = this.nbConflicts[i];
                    int n = tuple[i];
                    nArray[n] = nArray[n] + 1;
                    ++i;
                }
            } while (assistant.setNextTuple() != -1);
            assert (this.controlNbConflicts());
        }
        this.fixNbMaxConflictsAndCovering();
    }

    public boolean mayBeInconsistent(Variable variable) {
        if (this.nbConflicts == null) {
            return true;
        }
        int variablePosition = this.constraint.getPositionOf(variable);
        if (this.constraint.getDomainManager().getDCurrentDomainSizeExcluding(variablePosition) > (double)this.nbMaxConflicts[variablePosition]) {
            return false;
        }
        int i = 0;
        while (i < this.covering.length) {
            if (i != variablePosition) {
                int j = 0;
                while (j < this.covering[i].length) {
                    if (this.constraint.getInvolvedVariable(i).getDomain().hasIndex(this.covering[i][j])) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public void manageRemovedTuple(int[] tuple) {
        if (this.nbConflicts != null && !this.sharedStructures) {
            int i = 0;
            while (i < tuple.length) {
                int[] nArray = this.nbConflicts[i];
                int n = tuple[i];
                nArray[n] = nArray[n] + 1;
                ++i;
            }
        }
    }

    protected boolean controlNbConflicts() {
        if (this.nbConflicts == null) {
            return true;
        }
        int i = 0;
        while (i < this.nbConflicts.length) {
            Domain domain = this.constraint.getInvolvedVariable(i).getDomain();
            int j = 0;
            while (j < this.nbConflicts[i].length) {
                if (domain.hasIndex(j) && this.nbConflicts[i][j] != this.constraint.computeNbTuplesFor(i, j, false)) {
                    System.out.println("pb with " + this.constraint + " " + this.constraint.getInvolvedVariable(i) + " " + j);
                    System.out.println("  nbConflicts = " + this.nbConflicts[i][j] + " real nb conflicts = " + this.constraint.computeNbTuplesFor(i, j, false));
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void display() {
        if (this.nbConflicts == null) {
            return;
        }
        System.out.println("  Constraint  " + this.constraint);
        int i = 0;
        while (i < this.nbConflicts.length) {
            System.out.println("    Variable " + this.constraint.getInvolvedVariable(i));
            System.out.print("      nbConflicts = ");
            int j = 0;
            while (j < this.nbConflicts[i].length) {
                System.out.print(String.valueOf(this.nbConflicts[i][j]) + " ");
                ++j;
            }
            System.out.println();
            System.out.println("      max nb Conflicts = " + this.nbMaxConflicts[i]);
            System.out.print("      covering = ");
            j = 0;
            while (j < this.covering[i].length) {
                System.out.print(String.valueOf(this.covering[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

