/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints;

import abscon.constraints.Constraint;
import abscon.problem.Variable;
import java.util.Arrays;

public final class DomainManager {
    private Constraint constraint;
    private int[] nbRecentDomainRemovals;

    public DomainManager(Constraint constraint) {
        this.constraint = constraint;
        if (constraint.getProblem().getResolution() != null && !constraint.getProblem().getResolution().isPseudoCompetition()) {
            this.nbRecentDomainRemovals = new int[constraint.getNbInvolvedVariables()];
        }
    }

    public int[] getNbRecentDomainRemovals() {
        return this.nbRecentDomainRemovals;
    }

    public boolean hasRecentReducedDomain(Variable variable) {
        return this.nbRecentDomainRemovals[this.constraint.getPositionOf(variable)] > 0;
    }

    public boolean hasRecentReducedDomain(int position) {
        return this.nbRecentDomainRemovals[position] > 0;
    }

    public int getNbRecentReducedDomains() {
        int cpt = 0;
        int i = 0;
        while (i < this.nbRecentDomainRemovals.length) {
            if (this.nbRecentDomainRemovals[i] > 0) {
                ++cpt;
            }
            ++i;
        }
        return cpt;
    }

    public Variable getUniqueVariableWithReducedDomain() {
        Variable variable = null;
        int i = 0;
        while (i < this.nbRecentDomainRemovals.length) {
            if (this.nbRecentDomainRemovals[i] > 0) {
                if (variable == null) {
                    variable = this.constraint.getInvolvedVariable(i);
                } else {
                    return null;
                }
            }
            ++i;
        }
        return variable;
    }

    public void setNbRecentDomainRemovals(Variable variable, int nb) {
        this.nbRecentDomainRemovals[this.constraint.getPositionOf((Variable)variable)] = nb;
    }

    public void setNbRecentDomainRemovals(int nb) {
        Arrays.fill(this.nbRecentDomainRemovals, nb);
    }

    public void incrementNbRecentDomainRemovals(Variable variable, int nb) {
        int n = this.constraint.getPositionOf(variable);
        this.nbRecentDomainRemovals[n] = this.nbRecentDomainRemovals[n] + nb;
    }

    public boolean hasDomainSizeGreaterThan(int limit) {
        Variable[] involvedVariables = this.constraint.getInvolvedVariables();
        double size = involvedVariables[0].getDomain().getCurrentSize();
        int i = 1;
        while (size <= (double)limit && i < involvedVariables.length) {
            size *= (double)involvedVariables[i].getDomain().getCurrentSize();
            ++i;
        }
        return size > (double)limit;
    }

    private long getSize(boolean current, int position) {
        Variable[] involvedVariables = this.constraint.getInvolvedVariables();
        long sizeL = 1L;
        double sizeD = 1.0;
        int i = 0;
        while (i < involvedVariables.length) {
            if (i != position) {
                int domainSize = current ? involvedVariables[i].getDomain().getCurrentSize() : involvedVariables[i].getDomain().getMaximumSize();
                sizeL *= (long)domainSize;
                sizeD *= (double)domainSize;
            }
            ++i;
        }
        if (sizeL != (long)sizeD) {
            return -1L;
        }
        return sizeL;
    }

    public long getCurrentDomainSize() {
        return this.getSize(true, -1);
    }

    public long getCurrentDomainSizeExcluding(int position) {
        return this.getSize(true, position);
    }

    public long getMaximumDomainSize() {
        return this.getSize(false, -1);
    }

    public long getMaximumDomainSizeExcluding(int position) {
        return this.getSize(false, position);
    }

    public double getDCurrentDomainSize() {
        Variable[] involvedVariables = this.constraint.getInvolvedVariables();
        double size = 1.0;
        int i = 0;
        while (i < involvedVariables.length) {
            size *= (double)involvedVariables[i].getDomain().getCurrentSize();
            ++i;
        }
        return size;
    }

    public double getDCurrentDomainSizeExcluding(int position) {
        Variable[] involvedVariables = this.constraint.getInvolvedVariables();
        double size = 1.0;
        int i = 0;
        while (i < involvedVariables.length) {
            if (i != position) {
                size *= (double)involvedVariables[i].getDomain().getCurrentSize();
            }
            ++i;
        }
        return size;
    }

    public double getDCurrentDomainSizeExcluding(Variable variable) {
        double size = 1.0;
        Variable[] variableArray = this.constraint.getInvolvedVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable currentVariable = variableArray[n];
            if (currentVariable != variable) {
                size *= (double)currentVariable.getDomain().getCurrentSize();
            }
            ++n;
        }
        return size;
    }

    public double getDMaximumDomainSizeExcluding(int position) {
        Variable[] involvedVariables = this.constraint.getInvolvedVariables();
        double size = 1.0;
        int i = 0;
        while (i < involvedVariables.length) {
            if (i != position) {
                size *= (double)involvedVariables[i].getDomain().getMaximumSize();
            }
            ++i;
        }
        return size;
    }

    public double getDMaximumDomainSizeExcluding(Variable variable) {
        double size = 1.0;
        Variable[] variableArray = this.constraint.getInvolvedVariables();
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable currentVariable = variableArray[n];
            if (currentVariable != variable) {
                size *= (double)currentVariable.getDomain().getMaximumSize();
            }
            ++n;
        }
        return size;
    }
}

