/*
 * Decompiled with CFR 0.152.
 */
package abscon.constraints;

import abscon.constants.XMLInstanceRepresentation;
import abscon.constraints.ConflictsStructure;
import abscon.constraints.DomainManager;
import abscon.constraints.TupleManager;
import abscon.constraints.extension.ExtensionConstraint;
import abscon.constraints.extension.structures.ExtensionStructure;
import abscon.exceptions.MissingImplementationException;
import abscon.exceptions.UnreachableCodeException;
import abscon.problem.Problem;
import abscon.problem.Variable;
import abscon.problem.domains.Domain;
import abscon.propagationTechniques.PropagationTechnique;
import abscon.solvers.variableManagers.ConstraintVariableManager;
import abscon.solvers.variableManagers.VariableManager;
import abscon.tools.elements.Elements;
import abscon.tools.reflection.Reflector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Constraint {
    public static final Constraint TAG = new Constraint(){};
    public static final int INITIAL_WEIGHTED_DEGREE = 1;
    protected Problem problem;
    private String name;
    protected int id = -1;
    protected Variable[] involvedVariables;
    protected int[] positions;
    protected int weight = 1;
    protected String relationTypeName;
    public double tightness = -10.0;
    protected VariableManager variableManager;
    protected TupleManager tupleManager;
    protected DomainManager domainManager;
    protected ConflictsStructure conflictsStructure;
    private int futureLimitation = Integer.MAX_VALUE;
    private long counter;
    private long weightedDegree = 1L;
    private int nbEffectiveRevisions;
    protected boolean candidateAttentive;
    protected boolean indexValueSimilarity;
    protected boolean visible;
    protected int[] values;

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public double getTightness() {
        return this.tightness;
    }

    public boolean setLimitation(int futureLimitation, int spaceLimitation) {
        assert (futureLimitation > 0 || spaceLimitation > 0);
        if (futureLimitation != -1) {
            if (futureLimitation < this.involvedVariables.length) {
                this.futureLimitation = futureLimitation;
            }
        } else {
            if (this.involvedVariables.length <= 3) {
                return false;
            }
            double limit = Math.pow(2.0, spaceLimitation);
            Variable[] vars = (Variable[])this.involvedVariables.clone();
            Arrays.sort(vars, new Comparator<Variable>(){

                @Override
                public int compare(Variable v1, Variable v2) {
                    return v2.getDomain().getCurrentSize() - v1.getDomain().getCurrentSize();
                }
            });
            int i = 0;
            double prod = 1.0;
            while (i < vars.length && prod <= limit) {
                prod *= (double)vars[i].getDomain().getCurrentSize();
                ++i;
            }
            if (prod > limit) {
                this.futureLimitation = Math.max(1, i - 1);
            }
        }
        assert (this.futureLimitation > 0);
        return this.futureLimitation < this.involvedVariables.length;
    }

    public final long getCounter() {
        return this.counter;
    }

    public final void incrementCounter() {
        this.counter = Variable.incrementGlobalCounter();
    }

    public ExtensionStructure getExtensionStructure() {
        return null;
    }

    public boolean takesIntoAccountAllEventsWhenFiltering() {
        return true;
    }

    public boolean isGACGuaranteed() {
        return this.futureLimitation == Integer.MAX_VALUE;
    }

    public boolean canBeCurrentlyPropagated() {
        int nb = this.getNbFutureVariables();
        if (nb == 0) {
            return false;
        }
        return nb <= this.futureLimitation;
    }

    public int getNbEffectiveRevisions() {
        return this.nbEffectiveRevisions;
    }

    public void setNbEffectiveRevisions(int nb) {
        this.nbEffectiveRevisions = nb;
    }

    public void incrementNbEffectiveRevisionsOf(int increment) {
        this.nbEffectiveRevisions += increment;
    }

    public void resetNbEffectiveRevisions() {
        this.nbEffectiveRevisions = 0;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public String getDefaultName() {
        return "C" + this.problem.getQuotes() + this.id;
    }

    public String getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public String getName(boolean defaultName) {
        if (defaultName || this.name == null) {
            return this.getDefaultName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int i) {
        this.id = i;
    }

    public Variable[] getInvolvedVariables() {
        return this.involvedVariables;
    }

    public Variable getInvolvedVariable(int i) {
        return this.involvedVariables[i];
    }

    public int getNbInvolvedVariables() {
        return this.involvedVariables.length;
    }

    public int getArity() {
        return this.involvedVariables.length;
    }

    public String getRelationTypeName() {
        return this.relationTypeName;
    }

    public void setRelationTypeName(String relationTypeName) {
        this.relationTypeName = relationTypeName;
    }

    public int isSymmetric() {
        return -10;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean getIndexValueSimilarity() {
        return this.indexValueSimilarity;
    }

    public void setIndexValueSimilarity(boolean indexValueSimilarity) {
        this.indexValueSimilarity = indexValueSimilarity;
    }

    public int getPositionOf(Variable variable) {
        if (this.positions != null) {
            return this.positions[variable.getId()];
        }
        int i = 0;
        while (i < this.involvedVariables.length) {
            if (this.involvedVariables[i] == variable) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isBinding(Variable variable) {
        return this.getPositionOf(variable) != -1;
    }

    public boolean isBinding(Variable v1, Variable v2) {
        return this.isBinding(v1) && this.isBinding(v2);
    }

    public Variable getFirstFutureVariable() {
        return this.variableManager.getFirstFutureVariable();
    }

    public Variable getNextFutureVariableAfter(Variable variable) {
        return this.variableManager.getNextFutureVariableAfter(variable);
    }

    public int getNbPastVariables() {
        return this.variableManager.getNbPastVariables();
    }

    public int getNbDisconnectedVariables() {
        return this.variableManager.getNbDisconnectedVariables();
    }

    public int getNbFutureVariables() {
        return this.variableManager.getNbFutureVariables();
    }

    public int getNbFreeVariables() {
        int cpt = 0;
        Variable futureVariable = this.getFirstFutureVariable();
        while (futureVariable != null) {
            if (futureVariable.getDomain().getCurrentSize() != 1) {
                ++cpt;
            }
            futureVariable = this.getNextFutureVariableAfter(futureVariable);
        }
        return cpt;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public TupleManager getTupleManager() {
        return this.tupleManager;
    }

    public DomainManager getDomainManager() {
        return this.domainManager;
    }

    public ConflictsStructure getConflictsStructure() {
        return this.conflictsStructure;
    }

    public void setConflictsStructure(ConflictsStructure conflictsStructure) {
        this.conflictsStructure = conflictsStructure;
    }

    public boolean isCandidateAttentive() {
        return this.candidateAttentive;
    }

    public void setCandidateAttentive(boolean b) {
        this.candidateAttentive = b;
    }

    public long getWeightedDegree() {
        return this.weightedDegree;
    }

    public void setWeightedDegree(long weightedDegree) {
        this.weightedDegree = weightedDegree;
    }

    public void resetWeightedDegree() {
        this.weightedDegree = 1L;
    }

    public void incrementWeigthedDegree() {
        ++this.weightedDegree;
    }

    public void incrementWeigthedDegreeOf(int increment) {
        this.weightedDegree += (long)increment;
    }

    public Variable getFirstVariableDifferentFrom(Variable variable) {
        int i = 0;
        while (i < this.involvedVariables.length) {
            if (this.involvedVariables[i] != variable) {
                return this.involvedVariables[i];
            }
            ++i;
        }
        return null;
    }

    public boolean hasSetOfVariablesEqualTo(Variable[] variables) {
        if (this.involvedVariables.length != variables.length) {
            return false;
        }
        int i = 0;
        while (i < this.involvedVariables.length) {
            boolean found = false;
            int j = 0;
            while (!found && j < variables.length) {
                if (this.involvedVariables[i] == variables[j]) {
                    found = true;
                }
                ++j;
            }
            if (!found) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isBindingAtLeastOneVariableAmong(Variable[] variables) {
        int i = 0;
        while (i < variables.length) {
            if (this.isBinding(variables[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void fixPositions() {
        if (this.involvedVariables.length <= 3) {
            return;
        }
        this.positions = new int[this.problem.getNbVariables()];
        int i = 0;
        while (i < this.positions.length) {
            this.positions[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.involvedVariables.length) {
            this.positions[this.involvedVariables[i].getId()] = i;
            ++i;
        }
    }

    private boolean determineIndexValueSimilarity() {
        int i = 0;
        while (i < this.involvedVariables.length) {
            Domain domain = this.involvedVariables[i].getDomain();
            if (!domain.getIndexValueSimilarity()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Constraint() {
    }

    public Constraint(Problem problem, Variable[] involvedVariables, boolean visible) {
        this.problem = problem;
        this.involvedVariables = involvedVariables;
        this.visible = visible;
        if (!this.controlSignature(involvedVariables)) {
            throw new IllegalArgumentException("Incoherent signature of a constraint in " + this.getClass().getName());
        }
        this.fixPositions();
        this.variableManager = new ConstraintVariableManager(involvedVariables, this);
        if (problem.getResolution() == null || !problem.getResolution().isPseudoCompetition()) {
            this.tupleManager = new TupleManager(this);
        }
        this.domainManager = new DomainManager(this);
        if (visible) {
            int i = 0;
            while (i < involvedVariables.length) {
                involvedVariables[i].addInvolvingConstraint(this);
                ++i;
            }
        }
        if (problem.getResolution() == null || !problem.getResolution().isPseudoCompetition()) {
            this.values = new int[involvedVariables.length];
        }
        this.indexValueSimilarity = problem.getResolution() != null && problem.getResolution().isPseudoCompetition() ? true : this.determineIndexValueSimilarity();
    }

    public Constraint(Problem problem, Variable[] variables) {
        this(problem, variables, true);
    }

    public Constraint(Problem problem, Variable variable0, Variable variable1) {
        this(problem, new Variable[]{variable0, variable1}, true);
    }

    public Constraint(Problem problem, Variable variable0, Variable variable1, Variable variable2) {
        this(problem, new Variable[]{variable0, variable1, variable2}, true);
    }

    public int getNbMaxConflictsUpperBoundFor(Variable variable, int index) {
        return -10;
    }

    public int[] toValues(int[] tuple) {
        int i = 0;
        while (i < this.values.length) {
            this.values[i] = this.involvedVariables[i].getDomain().toValue(tuple[i]);
            ++i;
        }
        return this.values;
    }

    protected boolean check(int[] values) {
        throw new MissingImplementationException(" class " + this.getClass().getName());
    }

    public boolean checkCurrent() {
        this.problem.incrementNbConstraintChecks();
        int[] indexes = this.tupleManager.getLocalTuple();
        int i = 0;
        while (i < this.involvedVariables.length) {
            indexes[i] = this.involvedVariables[i].getDomain().getUniqueIndex();
            ++i;
        }
        return this.checkTupleOfIndexes(indexes);
    }

    public boolean checkTupleOfIndexes(int[] indexes) {
        if (this.indexValueSimilarity) {
            return this.check(indexes);
        }
        return this.check(this.toValues(indexes));
    }

    public final boolean checkCurrentTupleOfAssistant() {
        this.problem.incrementNbConstraintChecks();
        return this.checkTupleOfIndexes(this.tupleManager.getCurrentTuple());
    }

    public final boolean checkValidityOf(int[] support) {
        this.problem.incrementNbValidityChecks();
        int i = 0;
        while (i < support.length) {
            if (!this.involvedVariables[i].getDomain().hasIndex(support[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final boolean checkValidityOf(int[] support, int position) {
        this.problem.incrementNbValidityChecks();
        int i = 0;
        while (i < support.length) {
            if (i != position && !this.involvedVariables[i].getDomain().hasIndex(support[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean getFirstSupport(int[] t) {
        this.tupleManager.setFirstTupleFromScratch(t);
        return this.seekSupportFromAssistantTuple();
    }

    public boolean getNextSupport(int[] t) {
        if (this.tupleManager.setNextTupleStricltyGreaterThan(t) == -1) {
            return false;
        }
        return this.seekSupportFromAssistantTuple();
    }

    private final boolean seekSupportFromAssistantTuple() {
        do {
            if (!this.checkCurrentTupleOfAssistant()) continue;
            return true;
        } while (this.tupleManager.setNextTuple() != -1);
        return false;
    }

    final boolean seekSupportCandidateFromAssistantTuple() {
        assert (this.checkValidityOf(this.tupleManager.getCurrentTuple()));
        int result = this.tupleManager.seekCandidate(0);
        if (result == 0) {
            return false;
        }
        if (result == 2) {
            return true;
        }
        do {
            if (this.checkCurrentTupleOfAssistant()) {
                return true;
            }
            int modificationPosition = this.tupleManager.setNextTuple();
            if (modificationPosition == -1) {
                return false;
            }
            result = this.tupleManager.seekCandidate(modificationPosition);
            if (result != 0) continue;
            return false;
        } while (result != 2);
        return true;
    }

    public final boolean seekSupport(int[] tuple) {
        this.tupleManager.setFirstTupleFromScratch(tuple);
        return this.candidateAttentive ? this.seekSupportCandidateFromAssistantTuple() : this.seekSupportFromAssistantTuple();
    }

    public final boolean seekSupport() {
        return this.seekSupport(this.tupleManager.getLocalTuple());
    }

    public boolean seekSupport(int variablePosition, int index, int[] tuple) {
        this.tupleManager.setFirstTupleFromScratch(tuple, variablePosition, index);
        return this.candidateAttentive ? this.seekSupportCandidateFromAssistantTuple() : this.seekSupportFromAssistantTuple();
    }

    public final boolean seekSupport(int variablePosition1, int index1, int variablePosition2, int index2, int[] tuple) {
        this.tupleManager.setFirstTupleFromScratch(tuple, variablePosition1, index1, variablePosition2, index2);
        return this.candidateAttentive ? this.seekSupportCandidateFromAssistantTuple() : this.seekSupportFromAssistantTuple();
    }

    public final boolean seekSupport(int variablePosition, int index) {
        return this.seekSupport(variablePosition, index, this.tupleManager.getLocalTuple());
    }

    public final boolean seekSupport(int[] positions, int[] indexes, int nbElements, int[] tuple) {
        this.tupleManager.setFirstTupleFromScratch(tuple, positions, indexes, nbElements);
        return this.candidateAttentive ? this.seekSupportCandidateFromAssistantTuple() : this.seekSupportFromAssistantTuple();
    }

    public final boolean seekSupport(int[] positions, int[] indexes, int nbElements) {
        return this.seekSupport(positions, indexes, nbElements, this.tupleManager.getLocalTuple());
    }

    public boolean seekAnotherSupport(int variablePosition, int index, int[] tuple) {
        if (this.tupleManager.setNextTupleStrictlyGreaterThan(tuple, variablePosition, index) == -1) {
            return false;
        }
        return this.candidateAttentive ? this.seekSupportCandidateFromAssistantTuple() : this.seekSupportFromAssistantTuple();
    }

    public boolean removeTuple(int[] tuple) {
        throw new UnreachableCodeException();
    }

    protected Variable tryRemovalsFrom(Domain singletonDomain) {
        throw new MissingImplementationException("Class " + this.getClass().getName());
    }

    private boolean mustBeConsideredForSpecificFiltering(Variable variable) {
        int variablePosition = this.getPositionOf(variable);
        return variablePosition != -1 && this.domainManager.hasRecentReducedDomain(variablePosition);
    }

    public Variable isSpecificIncoherent() {
        Variable inconsistentVariable;
        Variable currentVariable;
        if (this.problem.getSolver().getCurrentDepth() != 0 && this.mustBeConsideredForSpecificFiltering(currentVariable = this.problem.getSolver().getVariableManager().getLastPastVariable()) && (inconsistentVariable = this.tryRemovalsFrom(currentVariable.getDomain())) != null) {
            return inconsistentVariable;
        }
        Variable futureVariable = this.getFirstFutureVariable();
        while (futureVariable != null) {
            Variable inconsistentVariable2;
            Domain futureDomain = futureVariable.getDomain();
            if (futureDomain.getCurrentSize() == 1 && this.domainManager.hasRecentReducedDomain(this.getPositionOf(futureVariable)) && (inconsistentVariable2 = this.tryRemovalsFrom(futureDomain)) != null) {
                return inconsistentVariable2;
            }
            futureVariable = this.getNextFutureVariableAfter(futureVariable);
        }
        return null;
    }

    public Variable isDefaultSpecificIncoherent() {
        Variable futureVariable = this.getFirstFutureVariable();
        while (futureVariable != null) {
            Domain futureDomain = futureVariable.getDomain();
            int futureVariablePosition = this.getPositionOf(futureVariable);
            int index = futureDomain.getFirstValidIndex();
            while (index != -1) {
                if (!this.seekSupport(futureVariablePosition, index)) {
                    futureDomain.removeElementAt(index, this);
                }
                index = futureDomain.getNextValidIndexAfter(index);
            }
            if (futureDomain.getCurrentSize() == 0) {
                return futureVariable;
            }
            futureVariable = this.getNextFutureVariableAfter(futureVariable);
        }
        return null;
    }

    public boolean isSubstitutableBy(Variable variable, int index, int otherIndex) {
        int position = this.getPositionOf(variable);
        int[] tuple = this.tupleManager.getLocalTuple();
        this.tupleManager.setFirstTupleFromScratch(tuple, position, index);
        do {
            tuple[position] = index;
            boolean b1 = this.checkCurrentTupleOfAssistant();
            tuple[position] = otherIndex;
            boolean b2 = this.checkCurrentTupleOfAssistant();
            if (!b1 || b2) continue;
            return false;
        } while (this.tupleManager.setNextTuple() != -1);
        return true;
    }

    private final int computeNbTuplesFromAssistantTuple(boolean allowed) {
        int cpt = 0;
        do {
            if (this.checkCurrentTupleOfAssistant() != allowed) continue;
            ++cpt;
        } while (this.tupleManager.setNextTuple() != -1);
        return cpt;
    }

    public int computeNbTuplesFor(int variablePosition, int index, boolean allowed) {
        this.tupleManager.setFirstTupleFromScratch(this.tupleManager.getLocalTuple(), variablePosition, index);
        return this.computeNbTuplesFromAssistantTuple(allowed);
    }

    public int getNbInitialConflictsFor(Variable variable, int index) {
        return -1;
    }

    public int computeApproximationOfNbConflictsFor(int variablePosition, int index, int sampleSize, Random random) {
        this.tupleManager.setFirstTupleFromScratch(this.tupleManager.getLocalTuple(), variablePosition, index);
        int[] tuple = this.tupleManager.getLocalTuple();
        int nbApproximatedConflicts = 0;
        int cnt = 0;
        while (cnt < sampleSize) {
            int i = 0;
            while (i < tuple.length) {
                if (i != variablePosition) {
                    tuple[i] = this.involvedVariables[i].getDomain().getElements().getRandomElement(random);
                }
                ++i;
            }
            if (!this.checkCurrentTupleOfAssistant()) {
                ++nbApproximatedConflicts;
            }
            ++cnt;
        }
        return nbApproximatedConflicts;
    }

    public void display() {
        System.out.println();
        System.out.println("Constraint " + this.getSignature());
        System.out.println("  Class = " + this.getClass().getName());
        if (this.canBeDefinedByAPredicate()) {
            System.out.println("  Predicate = " + this.getPredicateExpression(0));
        }
        System.out.println("  Relation Type Name = " + this.relationTypeName);
        System.out.println("  Symmetric = " + (this.isSymmetric() == -10 ? "undefined" : (this.isSymmetric() == 1 ? "true" : "false")));
        if (this.weight != 0) {
            System.out.println("  Weight = " + this.weight);
        }
    }

    public void displayExhaustively() {
        this.display();
        this.displayTuples();
    }

    public void displayTuples(boolean allowed) {
        String s = this.tupleManager.getStringListOfTuples(allowed);
        System.out.println("  " + (allowed ? "Allowed" : "Unallowed") + " tuples = {" + s + "}");
    }

    public void displayTuples() {
        String s = this.tupleManager.getStringListOfTuples();
        if (this instanceof ExtensionConstraint) {
            ((ExtensionConstraint)this).getExtensionStructure().displayExhaustively();
        }
        System.out.println(s);
        int position = s.lastIndexOf(35);
        assert (position != -1);
        int nbTuples = -1;
        nbTuples = s.substring(position + 1).startsWith("supports") ? Math.abs(Integer.parseInt(s.substring(position + 1 + "supports".length()))) : Math.abs(Integer.parseInt(s.substring(position + 1 + "conflicts".length())));
        System.out.println("  " + (s.charAt(position + 1) != 'C' ? "Allowed" : "Unallowed") + " tuples = {" + s.substring(0, position) + "}");
        System.out.println("  Number of tuples = " + nbTuples);
    }

    public String getStringListOfVariables(boolean defaultName) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.involvedVariables.length) {
            sb.append(String.valueOf(this.involvedVariables[i].getName(defaultName)) + (i < this.involvedVariables.length - 1 ? " " : ""));
            ++i;
        }
        return sb.toString();
    }

    public String getStringListOfVariables() {
        return this.getStringListOfVariables(false);
    }

    public String[] getNamesOfVariables(int mode) {
        String[] names = new String[this.involvedVariables.length];
        int i = 0;
        while (i < names.length) {
            names[i] = mode == 0 ? this.involvedVariables[i].getName(false) : (mode == 1 ? this.involvedVariables[i].getName(true) : (mode == 2 ? XMLInstanceRepresentation.getVariableNameFor(i) : "V" + this.problem.getQuotes() + (char)(105 + i)));
            ++i;
        }
        return names;
    }

    public String[] getNamesOfConstants(int mode) {
        return null;
    }

    public String getPredicateExpression(int mode) {
        Method method = Reflector.searchMethod(this.getClass(), "getPredicateExpression", 8);
        try {
            return (String)method.invoke(null, this.getNamesOfVariables(mode), this.getNamesOfConstants(mode));
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public String getPredicateDefinition() {
        return null;
    }

    public String getSignature() {
        String s = String.valueOf(this.getName()) + "(";
        int i = 0;
        while (i < this.involvedVariables.length - 1) {
            s = String.valueOf(s) + this.involvedVariables[i] + ",";
            ++i;
        }
        s = String.valueOf(s) + this.involvedVariables[this.involvedVariables.length - 1] + ")";
        return s;
    }

    public String toString() {
        return this.getSignature();
    }

    public boolean canBeDefinedByAPredicate() {
        return true;
    }

    public int computeNbSubstitutableValuesOf(Variable variable) {
        int cpt = 0;
        Elements elements = variable.getDomain().getElements();
        int index1 = elements.getFirstPresent();
        while (index1 != -1) {
            int index2 = elements.getFirstPresent();
            while (index2 != -1) {
                if (index2 != index1 && this.isSubstitutableBy(variable, index1, index2)) {
                    ++cpt;
                }
                index2 = elements.getNextPresent(index2);
            }
            index1 = elements.getNextPresent(index1);
        }
        return cpt;
    }

    public List<int[]> computeSubstitutabilityRelationOf(Variable variable) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        Elements elements = variable.getDomain().getElements();
        int index1 = elements.getFirstPresent();
        while (index1 != -1) {
            int index2 = elements.getFirstPresent();
            while (index2 != -1) {
                if (index2 != index1 && this.isSubstitutableBy(variable, index1, index2)) {
                    list.add(new int[]{index1, index2});
                }
                index2 = elements.getNextPresent(index2);
            }
            index1 = elements.getNextPresent(index1);
        }
        return list;
    }

    public void displaySubstitutabilityRelations() {
        Variable[] variableArray = this.involvedVariables;
        int n = 0;
        int n2 = variableArray.length;
        while (n < n2) {
            Variable variable = variableArray[n];
            List<int[]> list = this.computeSubstitutabilityRelationOf(variable);
            System.out.print("  Substitutability relation of " + variable + " = {");
            for (int[] t : list) {
                System.out.print(" " + t[0] + "<" + t[1]);
            }
            System.out.println(" }");
            ++n;
        }
    }

    private boolean controlSignature(Variable[] variables) {
        if (variables.length < 1) {
            System.out.println(" constraint " + this + " of arity 0");
            return false;
        }
        int i = 0;
        while (i < variables.length - 1) {
            int j = i + 1;
            while (j < variables.length) {
                if (variables[i] == variables[j]) {
                    System.out.println(" constraint " + this + " with a scope involving two times the variable " + variables[i]);
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void revise(PropagationTechnique propagationTechnique, Variable variable) {
        Domain domain = variable.getDomain();
        Elements elements = domain.getElements();
        int variablePosition = this.getPositionOf(variable);
        if (propagationTechnique.isBoundConsistency()) {
            while (elements.getNbPresentElements() > 0 && !propagationTechnique.isConsistent(this.id, variablePosition, elements.getFirstPresent())) {
                domain.removeElementAt(elements.getFirstPresent(), this);
            }
            while (elements.getNbPresentElements() > 1 && !propagationTechnique.isConsistent(this.id, variablePosition, elements.getLastPresent())) {
                domain.removeElementAt(elements.getLastPresent(), this);
            }
        } else {
            int index = elements.getFirstPresent();
            while (index != -1) {
                if (!propagationTechnique.isConsistent(this.id, variablePosition, index)) {
                    domain.removeElementAt(index, this);
                }
                index = elements.getNextPresent(index);
            }
        }
    }

    public boolean isConsistent() {
        PropagationTechnique propagationTechnique = this.problem.getSolver().getCurrentPropagationTechnique();
        return propagationTechnique.isConsistent(this);
    }

    public boolean isConsistent(Variable variable) {
        throw new MissingImplementationException();
    }

    public void triggerUponBacktracking() {
        throw new MissingImplementationException();
    }

    /* synthetic */ Constraint(Constraint constraint) {
        this();
    }
}

