/*
 * Decompiled with CFR 0.152.
 */
package abscon.constants;

import java.util.StringTokenizer;

public class Expr {
    public static final String ADD = "add";
    public static final String SUB = "sub";
    public static final String MUL = "mul";
    public static final String DIV = "div";
    public static final String MOD = "mod";
    public static final String POW = "pow";
    public static final String NEG = "neg";
    public static final String ABS = "abs";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String NOT = "not";
    public static final String AND = "and";
    public static final String OR = "or";
    public static final String XOR = "xor";
    public static final String EQ = "eq";
    public static final String NE = "ne";
    public static final String GT = "gt";
    public static final String GE = "ge";
    public static final String LT = "lt";
    public static final String LE = "le";
    public static final String ID = "id";
    public static final String VAR = "var";
    public static final String CST = "cst";
    public static final String NAME = "name";

    private static String function(String functionName, Object operand) {
        return operand + " " + functionName + " ";
    }

    private static String function(String functionName, Object operand1, Object operand2) {
        return operand1 + " " + operand2 + " " + functionName + " ";
    }

    public static String function(String functionName, Object operand1, Object operand2, Object operand3) {
        return operand1 + " " + operand2 + " " + operand3 + " " + functionName + " ";
    }

    public static String function(String functionName, Object[] operands) {
        String s = "";
        int i = 0;
        while (i < operands.length) {
            s = String.valueOf(s) + operands[i] + " ";
            ++i;
        }
        return String.valueOf(s) + functionName + " ";
    }

    public static String equ(Object operand1, Object operand2) {
        return Expr.function(EQ, operand1, operand2);
    }

    public static String equ(Object operand1, Object operand2, Object operand3) {
        return Expr.function(EQ, operand1, operand2, operand3);
    }

    public static String equ(Object[] operands) {
        return Expr.function(EQ, operands);
    }

    public static String diff(Object operand1, Object operand2) {
        return Expr.function(NE, operand1, operand2);
    }

    public static String gt(Object operand1, Object operand2) {
        return Expr.function(GT, operand1, operand2);
    }

    public static String gte(Object operand1, Object operand2) {
        return Expr.function(GE, operand1, operand2);
    }

    public static String lt(Object operand1, Object operand2) {
        return Expr.function(LT, operand1, operand2);
    }

    public static String lte(Object operand1, Object operand2) {
        return Expr.function(LE, operand1, operand2);
    }

    public static String not(Object operand1) {
        return Expr.function(NOT, operand1);
    }

    public static String and(Object operand1, Object operand2) {
        return Expr.function(AND, operand1, operand2);
    }

    public static String and(Object operand1, Object operand2, Object operand3) {
        return Expr.function(AND, operand1, operand2, operand3);
    }

    public static String or(Object operand1, Object operand2) {
        return Expr.function(OR, operand1, operand2);
    }

    public static String or(Object operand1, Object operand2, Object operand3) {
        return Expr.function(OR, operand1, operand2, operand3);
    }

    public static String different(Object[] operands) {
        return Expr.function("allDifferent", operands);
    }

    public static String allOrdered(Object[] operands) {
        return Expr.function("allOrdered", operands);
    }

    public static String abs(Object operand) {
        return Expr.function(ABS, operand);
    }

    public static String div(Object operand1, Object operand2) {
        return Expr.function(DIV, operand1, operand2);
    }

    public static String mul(Object operand1, Object operand2) {
        return Expr.function(MUL, operand1, operand2);
    }

    public static String mod(Object operand1, Object operand2) {
        return Expr.function(MOD, operand1, operand2);
    }

    public static String sub(Object operand1, Object operand2) {
        return Expr.function(SUB, operand1, operand2);
    }

    public static String add(Object operand1) {
        return Expr.function(ADD, operand1);
    }

    public static String add(Object operand1, Object operand2) {
        return Expr.function(ADD, operand1, operand2);
    }

    public static String pow(Object operand1, Object operand2) {
        return Expr.function(POW, operand1, operand2);
    }

    public static String id(Object operand) {
        return Expr.function(ID, operand);
    }

    public static String formatPredicate(String predicate) {
        StringTokenizer st = new StringTokenizer(predicate);
        String s = "";
        while (st.hasMoreTokens()) {
            s = String.valueOf(s) + st.nextToken() + (st.hasMoreTokens() ? " " : "");
        }
        return s;
    }

    public static String unformatPredicate(String predicate) {
        return predicate;
    }
}

